<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2011 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:exsl="http://exslt.org/common"
    xmlns:text="http://ametys.org/text/3.0"
    xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
    extension-element-prefixes="exsl text event">
    
    <xsl:import href="plugin:core://stylesheets/helper/text.xsl"/>
    
    <xsl:variable name="rangeType" select="/events/@range"/>
    <xsl:variable name="requestedTags" select="/events/@requested-tags"/>
    
    <xsl:template match="/">
        <fo:root>
            <fo:layout-master-set>
                <fo:simple-page-master master-name="page"
                    page-width="297mm" page-height="210mm" margin-left="0cm"
                    margin-right="0cm" margin-top="0cm" margin-bottom="0cm">
                    <fo:region-body margin-top="1cm" margin-bottom="1cm">
                        <xsl:call-template name="agenda-region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before extent="0cm">
                        <xsl:call-template name="agenda-region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after extent="0cm">
                        <xsl:call-template name="agenda-region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <xsl:apply-templates select="events"/>
            
        </fo:root>
    </xsl:template>
    
    <xsl:template name="agenda-region-before">
    </xsl:template>

    <xsl:template match="events">
        <fo:page-sequence master-reference="page">
            
            <xsl:call-template name="agenda-region-before"/>
            
            <fo:flow flow-name="xsl-region-body">
                <fo:block margin-left="1cm" margin-right="1cm">
                    <xsl:call-template name="agenda-main-body-block"/>
                    
                    <xsl:call-template name="service-title"/>
                    
                    <fo:block>
                        <xsl:call-template name="agenda-title-style"/>
                        
                        <xsl:call-template name="title"/>
                    </fo:block>
                    
                    <fo:block>
                        <xsl:apply-templates select="calendar"/>
                    </fo:block>
                </fo:block>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
    
    <xsl:template name="service-title">
    	<xsl:if test="/events/@title != ''">
        	<fo:block>
        		 <xsl:call-template name="service-title-style"/>
        		<xsl:value-of select="/events/@title"/>
        	</fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="title">
        <xsl:choose>
            <xsl:when test="$rangeType = 'month'">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="MMMM yyyy" value="{calendar/@current}"/>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_FROM_TO"/>
                    <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{calendar/week/day[position() = 1]/@raw}"/></i18n:param>
                    <i18n:param><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{calendar/week/day[position() = last()]/@raw}"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="calendar">
        <fo:table table-layout="fixed">
            <xsl:call-template name="agenda-table-style"/>
            
            <fo:table-body>
                <xsl:call-template name="header"/>
                <xsl:apply-templates select="week"/>
            </fo:table-body>
        </fo:table>
        
        <xsl:call-template name="legend"/>
    </xsl:template>
    
    <xsl:template name="header">
        <fo:table-row>
            <xsl:call-template name="agenda-header-style"/>
            <xsl:choose>
                <xsl:when test="$rangeType = 'month'">
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_MONDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_TUESDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_WEDNESDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_THURSDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_FRIDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_SATURDAY"/></fo:block>
                    </fo:table-cell>
                    <fo:table-cell>
                        <xsl:call-template name="agenda-th-style"/>
                        <fo:block><i18n:text i18n:key="CALENDAR_SERVICE_AGENDA_SUNDAY"/></fo:block>
                    </fo:table-cell>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="week/day">
                        <fo:table-cell>
                            <xsl:call-template name="agenda-th-style"/>
                            <fo:block>
                                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="EEEE" value="{@raw}"/>
                                <xsl:text> </xsl:text>
                                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="dd MMMM yyyy" value="{@raw}"/>
                            </fo:block>
                        </fo:table-cell>
                    </xsl:for-each>
                </xsl:otherwise>
            </xsl:choose>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template name="legend">
        <fo:block>
            <xsl:call-template name="agenda-legend-style"/>
            <xsl:for-each select="/events/tag-categories/category/tags/tag">
                <fo:inline>
                    <xsl:call-template name="agenda-legend-category-style">
                        <xsl:with-param name="category-number" select="position()"/>
                        <xsl:with-param name="category" select="@name"/>
                    </xsl:call-template>
                    
                    <xsl:call-template name="display-legend-item">
                        <xsl:with-param name="category-number" select="position()"/>
                    </xsl:call-template>
                </fo:inline>
            </xsl:for-each>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="display-legend-item">
        <xsl:param name="category-number"/>
        
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="week">
        <fo:table-row>
            <xsl:call-template name="agenda-row-style"/>
            <xsl:for-each select="day">
                <xsl:variable name="date" select="@date"/>
                <xsl:variable name="month-str" select="concat(/events/@year, '-', /events/@month)"/>
                <xsl:variable name="in-month" select="starts-with(@date, $month-str)"/>
                <fo:table-cell>
                    <xsl:call-template name="agenda-td-style">
                        <xsl:with-param name="rangeType" select="$rangeType"/>
                        <xsl:with-param name="date" select="$date"/>
                        <xsl:with-param name="in-month" select="$in-month"/>
                        <xsl:with-param name="today" select="/events/@today = @date"/>
                    </xsl:call-template>
                    <fo:block>
                        <xsl:if test="$rangeType = 'month'">
                            <fo:inline>
                                <xsl:call-template name="agenda-event-num-style"/>
                                <xsl:value-of select="@day"/>
                            </fo:inline>
                        </xsl:if>
                        <fo:block>
                            <xsl:call-template name="agenda-events-container-style"/>
                            <xsl:apply-templates select="/events/contents/event[event:isBetween($date, @start, @end)]"/>
                        </fo:block>
                    </fo:block>
                </fo:table-cell>
            </xsl:for-each>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="event">
        <xsl:variable name="categories"><xsl:call-template name="get-categories"/></xsl:variable>
        <xsl:variable name="category" select="exsl:node-set($categories)/category[1]"/>
        <fo:block>
            <xsl:call-template name="agenda-event-style">
                <xsl:with-param name="category-number" select="$category/@number"/>
                <xsl:with-param name="category" select="$category/@name"/>
            </xsl:call-template>
            <xsl:call-template name="display-event">
                <xsl:with-param name="category-number" select="$category/@number"/>
            </xsl:call-template>
        </fo:block>
    </xsl:template>
    
    <xsl:template name="display-event">
        <xsl:param name="category-number"/>
        <fo:inline>
            <xsl:call-template name="agenda-event-title-style"/>
            <xsl:value-of select="content/@title"/>
        </fo:inline>
    </xsl:template>
    
    <xsl:template name="get-categories">
        <xsl:variable name="event-tags" select="content/tags/*"/>
        <xsl:for-each select="/events/tag-categories/category/tags/tag">
            <xsl:variable name="tagName" select="@name"/>
            <xsl:if test="exsl:node-set($event-tags)[local-name() = $tagName]">
                <category name="{text:lowercase($tagName)}" number="{position()}"/>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="get-category">
        <xsl:variable name="event-tags" select="content/tags/*"/>
        <xsl:variable name="categories">
            <xsl:for-each select="/events/tag-categories/category/tags/tag">
                <xsl:variable name="tagName" select="@name"/>
                <xsl:if test="exsl:node-set($event-tags)[local-name() = $tagName]">
                    <category>
                        <xsl:value-of select="position()"/>
                    </category>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        <xsl:value-of select="exsl:node-set($categories)/category[position() = last()]"/>
    </xsl:template>
    
    <xsl:template name="agenda-main-body-block"/>
    
    <xsl:template name="service-title-style">
        <xsl:attribute name="font-size">16pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="text-align">left</xsl:attribute>
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-title-style">
        <xsl:attribute name="font-size">16pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="text-transform">uppercase</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:attribute name="space-after">5mm</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-table-style">
        <xsl:attribute name="width">100%</xsl:attribute>
        <xsl:attribute name="space-after">10mm</xsl:attribute>
        <xsl:attribute name="border-color">black</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thick</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-header-style">
        <xsl:attribute name="height">8mm</xsl:attribute>
        <xsl:attribute name="border-color">black</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">thick</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-th-style">
        <xsl:attribute name="border-color">black</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">medium</xsl:attribute>
        <xsl:attribute name="text-align">center</xsl:attribute>
        <xsl:attribute name="display-align">center</xsl:attribute>
        <xsl:attribute name="font-size">10pt</xsl:attribute>
        <xsl:attribute name="font-weight">bold</xsl:attribute>
        <xsl:attribute name="background-color">#ddd</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-row-style">
         <xsl:attribute name="keep-together.within-column">always</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-td-style">
        <xsl:param name="rangeType"/>
        <xsl:param name="date"/>
        <xsl:param name="in-month" select="false()"/>
        <xsl:param name="today" select="false()"/>
        
        <xsl:attribute name="height">
            <xsl:choose>
                <xsl:when test="$rangeType = 'month'">20mm</xsl:when>
                <xsl:otherwise>80mm</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:attribute name="border-color">black</xsl:attribute>
        <xsl:attribute name="border-style">solid</xsl:attribute>
        <xsl:attribute name="border-width">medium</xsl:attribute>
        <xsl:attribute name="margin">0mm</xsl:attribute>
        <xsl:attribute name="padding">1pt</xsl:attribute>
        <xsl:attribute name="background-color">
            <xsl:choose>
                <xsl:when test="$today">#ddd</xsl:when>
                <xsl:when test="$in-month">#eee</xsl:when>
                <xsl:otherwise>#fff</xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-event-num-style">
        <xsl:attribute name="font-size">8px</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-events-container-style">
        <xsl:attribute name="font-size">9pt</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-event-style">
    </xsl:template>
    
    <xsl:template name="agenda-event-title-style">
    </xsl:template>
    
    <xsl:template name="agenda-legend-style">
    </xsl:template>
    
    <xsl:template name="agenda-legend-category-style">
        <xsl:param name="category-number"/>
        <xsl:param name="category"/>
        
        <xsl:attribute name="font-size">9pt</xsl:attribute>
        <xsl:attribute name="space-start">10pt</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="agenda-region-body-definition"/>
    
    <xsl:template name="agenda-region-before-definition"/>
    
    <xsl:template name="agenda-region-after-definition"/>
    
</xsl:stylesheet>
