<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                extension-element-prefixes="resolver event">
    
    <xsl:import href="plugin:web://stylesheets/content/common2ical.xsl"/>
    
    <xsl:variable name="forceAllDayIfMidnight" select="true()"/>
    
    <xsl:template match="/">
        <text>
	        <xsl:text>BEGIN:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
	        <xsl:text>VERSION:2.0</xsl:text><xsl:value-of select="$nl"/>
	        <xsl:text>PRODID:-//Ametys/calendar//NONSGML v1.0//EN</xsl:text><xsl:value-of select="$nl"/>
            
            <xsl:copy-of select="events/timezones"/>
            
            <xsl:apply-templates select="events"/>
	        
	        <xsl:copy-of select="events/rawICS"/>
	        
	        <xsl:text>END:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
        </text>
    </xsl:template>
    
    <xsl:template match="events">
        <xsl:apply-templates select="contents/event/content[metadata/start-date and not(starts-with(@id, 'ics://'))]" mode="vevent-content"/>
    </xsl:template>
            
    <xsl:template match="content" mode="vevent-dtstart">
        <xsl:if test="metadata/start-date">
            <xsl:choose>
                <xsl:when test="event:isDatetime(@id, 'start-date')">
                    <xsl:choose>
                        <xsl:when test="$forceAllDayIfMidnight and (dateutils:isAtMidnight(metadata/start-date, '') and (not(metadata/end-date) or dateutils:isAtMidnight(metadata/end-date, '')))"><!-- consider as full day event -->
                            <xsl:text>DTSTART;VALUE=DATE:</xsl:text>
                            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyyMMdd" value="{metadata/start-date}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>DTSTART;VALUE=DATE-TIME:</xsl:text>
                            <xsl:value-of select="datetime:icalFormat(metadata/start-date)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>DTSTART;VALUE=DATE:</xsl:text><xsl:value-of select="datetime:icalFormat(metadata/start-date)"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content" mode="vevent-dtend">
        <xsl:if test="metadata/end-date">
            <xsl:choose>
                <xsl:when test="event:isDatetime(@id, 'end-date')">
                    <xsl:choose>
                        <xsl:when test="$forceAllDayIfMidnight and (dateutils:isAtMidnight(metadata/end-date, '') and (not(metadata/start-date) or dateutils:isAtMidnight(metadata/start-date, '')))"><!-- consider as full day event -->
                            <xsl:text>DTEND;VALUE=DATE:</xsl:text>
                            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyyMMdd" value="{metadata/end-date}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:text>DTEND;VALUE=DATE-TIME:</xsl:text>
                            <xsl:value-of select="datetime:icalFormat(metadata/end-date)"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                	<xsl:text>DTEND;VALUE=DATE:</xsl:text>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="yyyyMMdd" value="{metadata/end-date}"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
