<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
                xmlns:escaper="org.apache.commons.text.StringEscapeUtils"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:exsl="http://exslt.org/common"
                xmlns:math="java.lang.Math"
                xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
                xmlns:encoder="java.net.URLEncoder"
                extension-element-prefixes="resolver escaper ametys encoder exsl event">
                
    <xsl:import href="service:web://pages/services/common.xsl"/>
    <xsl:import href="service:web://pages/services/search/helpers/js/script.xsl"/>
    <xsl:import href="service:web://pages/services/search/helpers/html/criteria.xsl"/>
    <xsl:import href="service:web://pages/services/search/helpers/html/rss.xsl"/>
    <xsl:import href="service:web://pages/services/search/helpers/html/results.xsl"/>
    <xsl:import href="service:web://pages/services/search/helpers/html/links.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/links.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
    <xsl:param name="rendering-context" select="ametys:renderingContext()"/>
    
    <xsl:variable name="header" select="string(ametys:serviceParameter('header')/text())"/>
    <xsl:variable name="result-display-type" select="'ON_SAME_PAGE'"/>
    <xsl:variable name="serviceId" select="translate(substring-after(/search/zone-item/@id, 'zoneItem://'), '-', '')"/>
    
    <!-- Set to false to consider exclusive end date, ie. an event from 12/01 to 14/01 will be considered as 2 days event on 12/01 and 13/01-->
    <xsl:variable name="forceInclusiveEndDate" select="true()"/>
    <!-- Set to true to consider event with start and end date at 00:00 as full day event-->
    <xsl:variable name="forceAllDayIfMidnight" select="true()"/>
    
    <xsl:template name="common-service-head-js">
        <xsl:call-template name="calendar-search-service-head-js"/>
    </xsl:template>
    
    <xsl:template name="calendar-search-service-head-js">
        <script src="{$uri-prefix}/plugins/calendar/resources/js/CalendarSearchService.{ametys:lang()}.js" type="text/javascript"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title">
        <xsl:call-template name="common-service-body-nonempty-content-title-content">
            <xsl:with-param name="title" select="$header"/>
        </xsl:call-template>    
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div id="calendar-search-service-{$serviceId}">
            <xsl:call-template name="form-criteria"/>

            <xsl:call-template name="search-results"/>

            <div class="calendar-wrapper">
                <div id="calendar-{$serviceId}"></div>
                <xsl:call-template name="loading-indicator"/>
            </div>
            
            <xsl:call-template name="link"/>
            
            <xsl:call-template name="download-links"/>
        </div>
    </xsl:template>
    
    <xsl:template name="loading-indicator">
        <div class="loading" data-ametys-search-role="loading"></div>
    </xsl:template>
    
    <xsl:template name="form-criteria">
        <!-- <xsl:call-template name="js-sumit-bo"/> -->
        <form method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <div>
                <xsl:call-template name="form-search"/>
            </div>
        </form> 
    </xsl:template>
    
    <xsl:template name="search-results">
        <div data-ametys-search-role="search-results">
            
            <xsl:call-template name="tag-filter-menu"/>
        
            <xsl:call-template name="form-criteria-hidden"/>
            
            <xsl:call-template name="ics-errors"/>
            
            <xsl:call-template name="hits"/>
        </div>
    </xsl:template>
    
    <xsl:template name="ics-errors">
	    <xsl:if test="errors-ics and $rendering-context = 'back'">
	    
           <xsl:call-template name="display-errors">
              <xsl:with-param name="titleI18nKey" select="'plugin.calendar:CALENDAR_SERVICE_AGENDA_ICS_OVERSIZED'" />
              <xsl:with-param name="status" select="'OVERSIZED'" />
           </xsl:call-template>
                            
           <xsl:call-template name="display-errors">
              <xsl:with-param name="titleI18nKey" select="'plugin.calendar:CALENDAR_SERVICE_AGENDA_ICS_ERRORS'" />
              <xsl:with-param name="status" select="'ERROR'" />
           </xsl:call-template>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="display-errors">
        <xsl:param name="titleI18nKey" />
        <xsl:param name="status" />
        
        <xsl:if test="errors-ics/ics[@status = $status]">
            <xsl:variable name="htmlMessage">
                <ul>
                    <xsl:for-each select="errors-ics/ics[@status = $status]">
                       <li><xsl:value-of select="@url" /></li>
                    </xsl:for-each>
                </ul>
            </xsl:variable>    
            
            <xsl:call-template name="display-bo-warning-message">
                <xsl:with-param name="titleI18nKey" select="$titleI18nKey"/>
                <xsl:with-param name="htmlMessage" select="$htmlMessage"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="hits">
    
        <script type="text/template" data-ametys-search-role="json-hits">
            {
                "events": [<xsl:for-each select="/search/hits/hit">
                                <xsl:apply-templates select="." mode="json"/>
                                <xsl:if test="position() != last()">,</xsl:if>
                           </xsl:for-each>]
            }
        </script>
    </xsl:template>
    
    <xsl:template match="hit[content]" mode="json">
        <xsl:variable name="categories"><xsl:call-template name="get-categories"/></xsl:variable>
        <xsl:variable name="category" select="exsl:node-set($categories)/category[1]"/>
        <xsl:variable name="pages" select="ametys:referencedPages(content/@id)"/>
        <xsl:variable name="isDateTime" select="event:isDatetime(content/@id, 'start-date')"/>
        <xsl:variable name="fullDayEvent" select="not($isDateTime) or ($forceAllDayIfMidnight and (dateutils:isAtMidnight(content/attributes/start-date, '') and (not(content/attributes/end-date) or dateutils:isAtMidnight(content/attributes/end-date, ''))))"/><!-- consider as full day event -->
        {
            "title": "<xsl:value-of select="escaper:escapeJson(content/@title)"/>",
            "start": "<xsl:value-of select="content/attributes/start-date"/>",
            <xsl:if test="content/attributes/end-date">
                <xsl:choose>
                    <xsl:when test="$fullDayEvent and $forceInclusiveEndDate">
                        "end": "<xsl:value-of select="event:nextDay(content/attributes/end-date)"/>",
                    </xsl:when>
                    <xsl:otherwise>
                        "end": "<xsl:value-of select="content/attributes/end-date"/>",
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            "description": "<xsl:apply-templates select="." mode="json-description"/>",
            "allDay": <xsl:apply-templates select="." mode="json-allday"/>,
            <xsl:if test="$category">
                "category": "<xsl:value-of select="$category/@name"/>",
                "backgroundColor": "<xsl:value-of select="$category/@color"/>",
                "borderColor": "<xsl:value-of select="$category/@color"/>",
            </xsl:if>
            <xsl:if test="$pages">
            "url": "<xsl:value-of select="resolver:resolve('page', $pages/@id)"/>",
            </xsl:if>
            "id": "<xsl:value-of select="content/@id"/>"
        }
    </xsl:template>
    
    <xsl:template match="hit[content]" mode="json-description">
        <strong><xsl:value-of select="escaper:escapeJson(content/@title)"/></strong>
        <xsl:choose>
            <xsl:when test="normalize-space(content/attributes/abstract) != ''">
                <br/><xsl:value-of select="escaper:escapeJson(content/attributes/abstract)"/>
            </xsl:when>
            <xsl:otherwise>
                <br/><xsl:value-of select="escaper:escapeJson(ametys:contentExcerpt(content/@id, 'content', 100))"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="hit[content]" mode="json-allday">
        <xsl:text>true</xsl:text>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent = 'true']" mode="json">
        {
            "title": "<xsl:value-of select="escaper:escapeJson(event/title)"/>",
            "description": "<xsl:apply-templates select="." mode="json-description"/>",
            "start": "<xsl:value-of select="event/startDate"/>",
            <xsl:if test="event/endDate">
            "end": "<xsl:value-of select="event/endDate"/>",
            </xsl:if>
            "allDay": <xsl:apply-templates select="." mode="json-allday"/>,
            <xsl:if test="event/tag/@name">
                "backgroundColor": "<xsl:value-of select="event/tag/color/main"/>",
                "borderColor": "<xsl:value-of select="event/tag/color/main"/>",
                "category": "<xsl:value-of select="event/tag/@name"/>",
            </xsl:if>
            "id": "<xsl:value-of select="id"/>"
        }
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent = 'true']" mode="json-description">
        <strong><xsl:value-of select="escaper:escapeJson(event/title)"/></strong>
        <xsl:if test="event/description">
            <br/><xsl:value-of select="escaper:escapeJson(event/description)"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="hit[@icsEvent = 'true']" mode="json-allday">
        <xsl:text>true</xsl:text>
    </xsl:template>
    
    <xsl:template name="get-categories">
        <xsl:param name="event-tags" select="content/tags/*"/>
        <xsl:for-each select="/search/form/tag-facet/tag">
            <xsl:variable name="tagName" select="@name"/>
            <xsl:if test="exsl:node-set($event-tags)[local-name() = $tagName]">
                <category name="{$tagName}" number="{position()}" color="{color/main}"><xsl:value-of select="label"/></category>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template name="tag-filter-menu">
        <xsl:if test="/search/form/tag-facet/tag">
            <xsl:call-template name="tag-filter-menu-title"/>
            
            <div class="filter-checkbox-list" data-ametys-search-role="tag-filter">
                <xsl:apply-templates select="/search/form/tag-facet/tag" mode="tag-filter-menu">
                    <xsl:sort select="label"/>
                </xsl:apply-templates>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="tag-filter-menu-title">
        <div class="tag-filter-title">
            <i18n:text i18n:key="CALENDAR_SERVICE_SEARCH_FILTER_MENU_TITLE" i18n:catalogue="plugin.calendar"/>
        </div>
    </xsl:template>
    
    <xsl:template match="tag" mode="tag-filter-menu">
        <xsl:variable name="tagColor" select="color/main"/>
        
        <xsl:variable name="onchange"><xsl:call-template name="search-js-submit-button"/></xsl:variable>
                                                
        <div class="item-checkbox">
            <input type="checkbox" id="checkbox-{@name}" onchange="{$onchange}" value="{@name}">
                <xsl:if test="@selected = 'true'">
                    <xsl:attribute name="checked">checked</xsl:attribute>
                </xsl:if>
            </input>
            <label for="checkbox-{@name}" class="checked" data-category="{@name}" style="--color:{$tagColor}">
               <xsl:value-of select="label"/>
            </label>
        </div>
    </xsl:template>
    
    <xsl:template name="download-links">
        <div class="download-links">
            <xsl:call-template name="ics-link"/>
            <!-- <xsl:call-template name="pdf-link"/> -->
        </div>
    </xsl:template>
    
    <xsl:template name="ics-link">
        <xsl:if test="ametys:serviceViewParameter('ical-download') = 'true'">
            <a target="blank" class="download ics" data-ametys-search-role="ics-link" title="CALENDAR_SERVICE_SEARCH_ICS_DOWNLOAD" i18n:attr="title"><span><i18n:text i18n:key="CALENDAR_SERVICE_SEARCH_ICS_DOWNLOAD"/></span></a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="pdf-link">
        <!-- Not yet supported -->
        <xsl:if test="ametys:serviceViewParameter('pdf-download') = 'true'">
            <a target="blank" class="download pdf" data-ametys-search-role="pdf-link"><span><i18n:text i18n:key="CALENDAR_SERVICE_SEARCH_PDF_DOWNLOAD"/></span></a>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>