<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
                xmlns:event="org.ametys.plugins.calendar.events.EventHelper"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                extension-element-prefixes="resolver event dateutils datetime">
    
    <xsl:import href="plugin:web://stylesheets/content/common2ical.xsl"/>
    
    <!-- Set to false to consider exclusive end date, ie. an event from 12/01 to 14/01 will be considered as 2 days event on 12/01 and 13/01-->
    <xsl:variable name="forceInclusiveEndDate" select="true()"/>
    <!-- Set to true to consider event with start and end date at 00:00 as full day event-->
    <xsl:variable name="forceAllDayIfMidnight" select="true()"/>
    
    <xsl:template match="/">
        <text>
	        <xsl:text>BEGIN:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
	        <xsl:text>VERSION:2.0</xsl:text><xsl:value-of select="$nl"/>
	        <xsl:text>PRODID:-//Ametys/calendar//NONSGML v1.0//EN</xsl:text><xsl:value-of select="$nl"/>
            
            <xsl:copy-of select="/search/hits/timezones"/>
            
            <xsl:apply-templates select="/search/hits"/>
	        
            <!-- ICS events -->
	        <xsl:copy-of select="/search/hits/rawICS"/>
	        
	        <xsl:text>END:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
        </text>
    </xsl:template>
    
    <xsl:template match="hits">
        <xsl:apply-templates select="hit[not(@icsEvent)]"/>
    </xsl:template>
    
    <xsl:template match="hit[content]">
        <xsl:apply-templates select="content" mode="vevent-content"/>
    </xsl:template>

    <xsl:template match="content" mode="vevent-dtstart">
        <xsl:if test="attributes/start-date">
             <xsl:variable name="isDateTime" select="event:isDatetime(@id, 'start-date')"/>
             <xsl:variable name="fullDayEvent" select="not($isDateTime) or ($forceAllDayIfMidnight and (dateutils:isAtMidnight(attributes/start-date, '') and (not(attributes/end-date) or dateutils:isAtMidnight(attributes/end-date, ''))))"/><!-- consider as full day event -->
             <xsl:choose>
                <xsl:when test="$fullDayEvent">
                    <xsl:text>DTSTART;VALUE=DATE:</xsl:text>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyyMMdd" value="{attributes/start-date}"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>DTSTART;VALUE=DATE-TIME:</xsl:text>
                    <xsl:value-of select="datetime:icalFormat(attributes/start-date)"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content" mode="vevent-dtend">
        <xsl:if test="attributes/end-date">
            <xsl:variable name="isDateTime" select="event:isDatetime(@id, 'end-date')"/>
            <xsl:variable name="fullDayEvent" select="not($isDateTime) or ($forceAllDayIfMidnight and (dateutils:isAtMidnight(attributes/start-date, '') and (not(attributes/end-date) or dateutils:isAtMidnight(attributes/end-date, ''))))"/><!-- consider as full day event -->
            <xsl:choose>
                <xsl:when test="$fullDayEvent and $forceInclusiveEndDate">
                    <xsl:text>DTEND;VALUE=DATE:</xsl:text>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyyMMdd" value="{event:nextDay(attributes/end-date)}"/>
                </xsl:when>
                <xsl:when test="$fullDayEvent">
                    <xsl:text>DTEND;VALUE=DATE:</xsl:text>
                    <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="yyyyMMdd" value="{attributes/end-date}"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>DTEND;VALUE=DATE-TIME:</xsl:text>
                    <xsl:value-of select="datetime:icalFormat(attributes/end-date)"/>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="$nl"/>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content" mode="vevent-summary">
        <xsl:text>SUMMARY:</xsl:text>
        <xsl:value-of select="attributes/title"/>
        <xsl:value-of select="$nl"/>
    </xsl:template>
    
</xsl:stylesheet>
