/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.LoggerFactory;

public class CartsDAO
implements Serviceable,
Component {
    public static final String ROLE = CartsDAO.class.getName();
    protected UserManager _userManager;
    private CurrentUserProvider _userProvider;
    private AmetysObjectResolver _resolver;
    private UserHelper _userHelper;
    private RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._userProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userHelper = (UserHelper)serviceManager.lookup(UserHelper.ROLE);
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    @Callable(rights={""})
    public Map<String, Object> getCartsInformation(List<String> cartIds) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<Map<String, Object>> carts = new LinkedList<Map<String, Object>>();
        LinkedList<Map<String, Object>> notAllowedCarts = new LinkedList<Map<String, Object>>();
        HashSet<String> unknownCarts = new HashSet<String>();
        for (String id : cartIds) {
            Cart cart = this.getCart(id);
            if (cart != null) {
                if (this._hasRight(cart)) {
                    carts.add(this.getCartProperties(cart));
                    continue;
                }
                notAllowedCarts.add(this.getCartProperties(cart));
                continue;
            }
            unknownCarts.add(id);
        }
        result.put("carts", carts);
        result.put("unknownCarts", unknownCarts);
        result.put("notAllowedCarts", notAllowedCarts);
        return result;
    }

    @Callable(rights={"Plugin_Cart_Rights_Create"})
    public Map<String, String> createCart(String title, String description, String documentation) {
        HashMap<String, String> result = new HashMap<String, String>();
        ModifiableTraversableAmetysObject cartsNode = CartHelper.getCartsNode(this._resolver);
        Object name = NameHelper.filterName((String)title);
        int index = 1;
        String originalName = name;
        while (cartsNode.hasChild((String)name)) {
            name = originalName + "_" + ++index;
        }
        String realTitle = title + (String)(index > 1 ? " (" + index + ")" : "");
        Cart cart = (Cart)cartsNode.createChild((String)name, "ametys:cart");
        cart.setTitle(realTitle);
        cart.setDescription(description);
        cart.setDocumentation(documentation);
        cart.setAuthor(this._userProvider.getUser());
        cart.setContributor(this._userProvider.getUser());
        cart.setCreationDate(ZonedDateTime.now());
        cart.setLastModificationDate(ZonedDateTime.now());
        cartsNode.saveChanges();
        result.put("id", cart.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, String> updateCart(String id, String title, String description, String documentation) {
        HashMap<String, String> result = new HashMap<String, String>();
        Cart cart = (Cart)this._resolver.resolveById(id);
        if (this.canWrite(this._userProvider.getUser(), cart)) {
            cart.setTitle(title);
            cart.setDescription(description);
            cart.setDocumentation(documentation);
            cart.setContributor(this._userProvider.getUser());
            cart.setLastModificationDate(ZonedDateTime.now());
            cart.saveChanges();
        } else {
            result.put("message", "not-allowed");
        }
        result.put("id", cart.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteCarts(List<String> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> deletedCarts = new ArrayList<String>();
        ArrayList<String> unknownCarts = new ArrayList<String>();
        ArrayList<String> notallowedCarts = new ArrayList<String>();
        for (String id : ids) {
            try {
                Cart cart = (Cart)this._resolver.resolveById(id);
                if (this.canWrite(this._userProvider.getUser(), cart)) {
                    cart.remove();
                    cart.saveChanges();
                    deletedCarts.add(id);
                    continue;
                }
                notallowedCarts.add(cart.getTitle());
            }
            catch (UnknownAmetysObjectException e) {
                unknownCarts.add(id);
                LoggerFactory.getLogger(this.getClass()).error("Unable to delete cart. The cart of id '" + id + " doesn't exist", (Throwable)e);
            }
        }
        result.put("deletedCarts", deletedCarts);
        result.put("notallowedCarts", notallowedCarts);
        result.put("unknownCarts", unknownCarts);
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> addElements(String cartId, String type, Map<String, Object> elementParams) {
        Cart cart;
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserIdentity user = this._userProvider.getUser();
        if (!this.canWrite(user, cart = (Cart)this._resolver.resolveById(cartId))) {
            LoggerFactory.getLogger(this.getClass()).error("User '{}' try to add elements to a cart without convenient privileges", (Object)user);
            result.put("msg", "not-allowed");
            return result;
        }
        switch (Cart.CartElementType.valueOf(type.toUpperCase())) {
            case CONTENT: {
                List contentIds = (List)elementParams.get("ids");
                for (String contentId : contentIds) {
                    cart.addContent(contentId);
                }
                break;
            }
            case RESOURCE: {
                List resourceIds = (List)elementParams.get("ids");
                for (String resourceId : resourceIds) {
                    cart.addResource(resourceId);
                }
                break;
            }
            case CARTQUERY: {
                String title = (String)elementParams.get("title");
                String description = (String)elementParams.get("description");
                cart.addQuery(user, title, description);
                break;
            }
            case CARTQUERYFROMDIRECTORY: {
                List queryIds = (List)elementParams.get("queryIds");
                for (String queryId : queryIds) {
                    cart.addQueryFormDirectory(queryId);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cart element type");
            }
        }
        cart.setContributor(this._userProvider.getUser());
        cart.setLastModificationDate(ZonedDateTime.now());
        cart.saveChanges();
        result.put("id", cart.getId());
        return result;
    }

    @Callable(rights={""})
    public Map<String, Object> deleteElements(String cartId, List<Map<String, String>> cartElements) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Cart cart = (Cart)this._resolver.resolveById(cartId);
        UserIdentity user = this._userProvider.getUser();
        if (!this.canWrite(user, cart)) {
            LoggerFactory.getLogger(this.getClass()).error("User '{}' try to add elements to a cart without convenient privileges", (Object)user);
            result.put("msg", "not-allowed");
            return result;
        }
        for (Map<String, String> cartElement : cartElements) {
            Cart.CartElementType type = Cart.CartElementType.valueOf(cartElement.get("type").toUpperCase());
            cart.removeElement(cartElement.get("id"), type);
        }
        cart.setContributor(this._userProvider.getUser());
        cart.setLastModificationDate(ZonedDateTime.now());
        cart.saveChanges();
        result.put("id", cartId);
        return result;
    }

    public Cart getCart(String cartId) {
        try {
            return (Cart)this._resolver.resolveById(cartId);
        }
        catch (AmetysRepositoryException e) {
            if (LoggerFactory.getLogger(this.getClass()).isWarnEnabled()) {
                LoggerFactory.getLogger(this.getClass()).warn("Failed to retrieves the cart with id : " + cartId, (Throwable)e);
            }
            return null;
        }
    }

    public Map<String, Object> getCartProperties(Cart cart) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        infos.put("id", cart.getId());
        infos.put("title", cart.getTitle());
        infos.put("description", cart.getDescription());
        infos.put("documentation", cart.getDocumentation());
        infos.put("author", this._userHelper.user2json(cart.getAuthor()));
        infos.put("contributor", this._userHelper.user2json(cart.getContributor()));
        infos.put("lastModificationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)cart.getLastModificationDate()));
        infos.put("creationDate", DateUtils.zonedDateTimeToString((ZonedDateTime)cart.getCreationDate()));
        UserIdentity currentUser = this._userProvider.getUser();
        infos.put("canRead", this.canRead(currentUser, cart));
        infos.put("canWrite", this.canWrite(currentUser, cart));
        infos.put("canAssignRights", this.canAssignRights(currentUser, cart));
        return infos;
    }

    protected boolean _hasRight(Cart cart) {
        UserIdentity user = this._userProvider.getUser();
        return this.canRead(user, cart) || this.canWrite(user, cart);
    }

    public boolean canRead(UserIdentity userIdentity, Cart cart) {
        return this._rightManager.hasReadAccess(userIdentity, (Object)cart);
    }

    public boolean canWrite(UserIdentity userIdentity, Cart cart) {
        return this._rightManager.hasRight(userIdentity, "Cart_Rights_Admin", (Object)cart) == RightManager.RightResult.RIGHT_ALLOW;
    }

    public boolean canAssignRights(UserIdentity userIdentity, Cart cart) {
        return this.canWrite(userIdentity, cart) || this._rightManager.hasRight(userIdentity, "Runtime_Rights_Rights_Handle", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
    }
}

