/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.generators;

import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.cart.CartElement;
import org.ametys.plugins.cart.CartsDAO;
import org.ametys.plugins.cart.ContentElement;
import org.ametys.plugins.cart.QueryFromDirectoryElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.version.VersionAwareAmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.store.AmetysStep;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CartElementsGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;
    protected CurrentUserProvider _userProvider;
    protected UserManager _userManager;
    protected CartsDAO _cartsDAO;
    protected ContentTypeExtensionPoint _cTypeEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._workflowProvider = (WorkflowProvider)smanager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)smanager.lookup(WorkflowHelper.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._userProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._cartsDAO = (CartsDAO)smanager.lookup(CartsDAO.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String id = request.getParameter("cartId");
        Cart cart = (Cart)this._resolver.resolveById(id);
        this.contentHandler.startDocument();
        UserIdentity user = this._userProvider.getUser();
        if (this._cartsDAO.canRead(user, cart)) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", cart.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"cart", (Attributes)attrs);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"label", (String)cart.getTitle());
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"description", (String)cart.getDescription());
            List<CartElement> elements = cart.getElements();
            for (CartElement elmt : elements) {
                this._saxElement(elmt);
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"total", (String)String.valueOf(elements.size()));
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"cart");
        } else {
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"not-allowed");
        }
        this.contentHandler.endDocument();
    }

    protected void _saxElement(CartElement elmt) throws SAXException {
        List<I18nizableText> groups = elmt.getGroups();
        for (I18nizableText group : groups) {
            String mediumIcon;
            String smallIcon;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", elmt.getId());
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"cartElement", (Attributes)attrs);
            elmt.getTitle().toSAX(this.contentHandler, "title");
            elmt.getDescription().toSAX(this.contentHandler, "description");
            group.toSAX(this.contentHandler, "group");
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creation", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)elmt.getCreationDate()));
            UserIdentity creatorIdentity = elmt.getCreator();
            User creator = this._userManager.getUser(creatorIdentity);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"creator", (String)(creator != null ? creator.getFullName() : ""));
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastModification", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)elmt.getLastModified()));
            UserIdentity lastContributorIdentity = elmt.getLastContributor();
            User lastContributor = this._userManager.getUser(lastContributorIdentity);
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"lastContributor", (String)(lastContributor != null ? lastContributor.getFullName() : ""));
            String glyphIcon = elmt.getGlyphIcon();
            if (glyphIcon != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"iconGlyph", (String)glyphIcon);
            }
            if ((smallIcon = elmt.getSmallIcon()) != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"smallIcon", (String)smallIcon);
            }
            if ((mediumIcon = elmt.getSmallIcon()) != null) {
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"mediumIcon", (String)mediumIcon);
            }
            XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"type", (String)elmt.getType());
            if (elmt instanceof ContentElement) {
                Content content = (Content)this._resolver.resolveById(elmt.getId());
                this._saxWorkflowStep(content);
            } else if (elmt instanceof QueryFromDirectoryElement) {
                QueryFromDirectoryElement queryElement = (QueryFromDirectoryElement)elmt;
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"documentation", (String)queryElement.getQuery().getDocumentation());
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"queryType", (String)queryElement.getQuery().getType());
            }
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"cartElement");
        }
    }

    protected void _saxWorkflowStep(Content content) throws SAXException {
        if (content instanceof WorkflowAwareContent) {
            WorkflowAwareContent waContent = (WorkflowAwareContent)content;
            try {
                WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)waContent);
                long workflowId = waContent.getWorkflowId();
                String workflowName = workflow.getWorkflowName(workflowId);
                Step currentStep = this._getCurrentStep(waContent, workflow);
                int currentStepId = currentStep.getStepId();
                I18nizableText workflowStepName = new I18nizableText("application", this._workflowHelper.getStepName(workflowName, currentStepId));
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "id", "id", "CDATA", String.valueOf(currentStepId));
                if ("application".equals(workflowStepName.getCatalogue())) {
                    atts.addAttribute("", "icon-small", "icon-small", "CDATA", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-small.png");
                    atts.addAttribute("", "icon-medium", "icon-medium", "CDATA", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-medium.png");
                    atts.addAttribute("", "icon-large", "icon-large", "CDATA", "/plugins/cms/resources_workflow/" + workflowStepName.getKey() + "-large.png");
                } else {
                    String pluginName = workflowStepName.getCatalogue().substring("plugin.".length());
                    atts.addAttribute("", "icon-small", "icon-small", "CDATA", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-small.png");
                    atts.addAttribute("", "icon-medium", "icon-medium", "CDATA", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-medium.png");
                    atts.addAttribute("", "icon-large", "icon-large", "CDATA", "/plugins/" + pluginName + "/resources/img/workflow/" + workflowStepName.getKey() + "-large.png");
                }
                XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"workflow-step", (Attributes)atts);
                workflowStepName.toSAX(this.contentHandler);
                XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"workflow-step");
            }
            catch (AmetysRepositoryException ametysRepositoryException) {
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
        }
    }

    protected Step _getCurrentStep(WorkflowAwareContent content, WorkflowProvider.AmetysObjectWorkflow workflow) throws WorkflowException {
        Object[] allRevisions;
        int currentRevIndex;
        VersionAwareAmetysObject vaContent;
        String currentRevision;
        long workflowId = content.getWorkflowId();
        Step currentStep = (Step)workflow.getCurrentSteps(workflowId).get(0);
        if (content instanceof VersionAwareAmetysObject && (currentRevision = (vaContent = (VersionAwareAmetysObject)content).getRevision()) != null && (currentRevIndex = ArrayUtils.indexOf((Object[])(allRevisions = vaContent.getAllRevisions()), (Object)currentRevision)) > -1 && currentRevIndex < allRevisions.length - 1) {
            AmetysStep amStep;
            Date nextRevTimestamp;
            Object nextRevision = allRevisions[currentRevIndex + 1];
            Date currentRevTimestamp = vaContent.getRevisionTimestamp();
            List steps = this._workflowHelper.getStepsBetween((Workflow)workflow, workflowId, currentRevTimestamp, nextRevTimestamp = vaContent.getRevisionTimestamp((String)nextRevision));
            if (steps.size() > 0 && steps.get(0) instanceof AmetysStep && (amStep = (AmetysStep)steps.get(0)).getProperty("actionFinishDate") != null) {
                steps = steps.subList(1, steps.size());
            }
            Collections.sort(steps, new Comparator<Step>(this){

                @Override
                public int compare(Step step1, Step step2) {
                    return -Long.valueOf(step1.getId()).compareTo(step2.getId());
                }
            });
            if (steps.size() > 0) {
                currentStep = (Step)steps.get(0);
            }
        }
        return currentStep;
    }
}

