/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.cart.observers;

import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.cart.Cart;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ContentDeletedObserver
implements Observer,
Serviceable {
    private AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.deleted");
    }

    public int getPriority() {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Map args = event.getArguments();
        String contentId = (String)args.get("content.id");
        String xPathQuery = "//element(*, ametys:cart)[@ametys:contents = '" + contentId + "']";
        AmetysObjectIterable carts = this._resolver.query(xPathQuery);
        for (Cart cart : carts) {
            cart.removeElement(contentId, Cart.CartElementType.CONTENT);
            cart.saveChanges();
        }
    }
}

