/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This factory creates Ametys.message.MessageTarget for a cart.
 * See #createTargets for more details.
 * @private
 */
Ext.define('Ametys.plugins.cart.CartMessageTargetFactory', {
	extend: 'Ametys.message.factory.DefaultMessageTargetFactory',
		
	/**
	 * Create the targets for a message
	 * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
	 * @param {String[]} parameters.ids The cart's identifiers.
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
	 */
	createTargets: function(parameters, callback)
	{
        if (parameters.ids || parameters.id)
        {
            var ids = parameters.ids || Ext.Array.from(parameters.id);
            Ametys.plugins.cart.CartsDAO.getCarts(ids, Ext.bind(this._createTargets, this, [callback, parameters], 1));
        }
        else if (parameters.carts)
        {
            this._createTargets (parameters.carts, callback, parameters);
        }
	},

	/**
	 * Create the carts targets
	 * @param {Ametys.plugins.cart.Cart[]} carts Array of carts.
	 * @param {Function} callback The callback function called when the targets are created. Parameters are
	 * @param {Ametys.message.MessageTarget[]} callback.targets The targets created. Cannot be null.
     * @param {Object} parameters The parameters needed by the factory to create the message. Can not be null. Handled elements are
     * @param {String[]} parameters.ids The cart's identifiers.
	 * @private
	 */
	_createTargets: function (carts, callback, parameters)
	{
        delete parameters['ids'];
        delete parameters['carts'];
        
		var targets = [];
		
		Ext.Array.forEach(carts, function(cart) {
            
            targets.push(Ext.create("Ametys.message.MessageTarget", {
                id: Ametys.message.MessageTarget.CART,
                parameters: Ext.merge(cart.getProperties(parameters || {}), {cart: cart})
            }));
		}, this);
			
		callback(targets);
	}
});

Ext.define("Ametys.message.CartMessageTarget",
    {
        override: "Ametys.message.MessageTarget",
        
        statics: 
        {
            /**
             * @member Ametys.message.MessageTarget
             * @readonly
             * @property {String} CART The target type is a cart. Ametys.plugins.cart.CartMessageTargetFactory parameters to know more of the associated parameters. 
             */
            CART: "cart"
        }
    }
);

