/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Cart context for profile assignments.
 */
Ext.define('Ametys.plugins.cart.CartRightAssignmentContext', {
    extend: 'Ametys.plugins.coreui.profiles.AbstractRightAssignmentContext',

    constructor: function(config)
    {
        this.callParent(arguments);
    },
    
    getComponent: function()
    {
        this._grid = Ext.create("Ametys.plugins.cart.tool.CartsPanel", { 
            stateful: true,
            stateId: this.self.getName() + "$grid",
            profile: 'right_access',
            listeners: {
                selectionchange: {fn: this._onSelectionChanged, scope: this}
            }
        });
        
        if (this._config.restrictContext)
        {
            return this._grid;
        }
        else
        {

            var items = [{
                    xtype: 'radiofield',
                    boxLabel  : "{{i18n PLUGINS_CART_RIGHT_ASSIGNMENT_CONTEXT_CART_RADIO_OPTION_ALL}}",
                    name      : 'radio-cart',
                    itemId: 'radio-cart-all',
                    checked: true,
                    inputValue: 'all',
                    style: {
                        marginLeft: '5px'
                    }
                }, {
                    xtype: 'radiofield',
                    boxLabel  : "{{i18n PLUGINS_CART_RIGHT_ASSIGNMENT_CONTEXT_CART_RADIO_OPTION_CART}}",
                    name      : 'radio-cart',
                    inputValue: 'content-type',
                    itemId: 'radio-cart-cart',
                    handler: this._onSelect,
                    scope: this,
                    style: {
                        marginLeft: '5px'
                    }
                }, this._grid
            ];
            
            this._container = Ext.create('Ext.container.Container', {
                layout: {
                    type: "vbox",
                    align: "stretch"
                },
                items: items
            });
            
            return this._container;
        }
    },

    initialize: function()
    {
        // Reload grid
        this._grid.getStore().load({
            callback: function()
            {
                var recordToSelect;
                if (this._cartIdToSelect != null)
                {
                    recordToSelect = this._grid.getStore().getById(this._cartIdToSelect);        
                    this._grid.setSelection(recordToSelect);
                }
                else if(this._config.restrictContext)
                {

                    recordToSelect = this._grid.getStore().getData().getAt(0);        
                    this._grid.setSelection(recordToSelect);
                }
            },
            scope: this
        });

        if (!this._config.restrictContext)
        {
            if (this._cartIdToSelect != null)
            {
                this._switchToCartMode();
            }
            else
            {
                this._switchToAllCartsMode();
            }
        }
    },

    isSupported: function (message)
    {
        return message.getTargets(Ametys.message.MessageTarget.CART).length > 0;
    },
    
    initContext: function (message)
    {
        this._cartIdToSelect = null;
        
        var cartTarget = message.getTarget();
        if (cartTarget != null)
        {
            this._cartIdToSelect = cartTarget.getParameters().id;
        }
    },
    

    /**
     * @private
     * Listener when the selection in the grid has changed
     * @param {Ext.selection.Model} model The selection model
     * @param {Ext.data.Model[]} selected The selected records
     */
    _onSelectionChanged: function(model, selected)
    {
        if (selected.length > 0 && ! selected[0].data.root)
        {
            var object = selected[0];
            var hintTextContext ="{{i18n PLUGINS_CART_CARTACCESS_CONTEXT_HINT_CART}} <b>" + selected[0].get('title') + "</b>";
            
            this._changeObjectContext(object.get('id'), hintTextContext, false);
        }
    },

    /**
     * @private
     * Handler when selection an option
     * @param {Ext.form.Checkbox} contentTypeCheckbox The content type checkbox
     * @param {Boolean} contentTypeChecked Is content type checked?
     */
    _onSelect: function (contentTypeCheckbox, contentTypeChecked)
    {
        if (contentTypeChecked)
        {
            // Enable search
            this._switchToCartMode();
        }
        else
        {
            // Disable search
            this._switchToAllCartsMode();
        }
    },
    
    /**
     * @private
     * Switch to the "all contents" mode
     */
    _switchToAllCartsMode: function()
    {
        this._container.down('#radio-cart-all').setValue(true);
        this._changeObjectContext("/carts", "<b>{{i18n PLUGINS_CART_CARTACCESS_CONTEXT_HINT_ALL}}</b>", false, true);
        
        // Disable search result grid
        this._grid.getSelectionModel().deselectAll();
        this._grid.mask("{{i18n PLUGINS_CART_CARTACCESS_CONTEXT_CART_MASK}}", 'ametys-mask-unloading');
    },

    /**
     * @private
     * Swith to "content type" mode
     */
    _switchToCartMode: function()
    {
        this._container.down('#radio-cart-cart').setValue(true);
        this._grid.unmask();
    }
});
