/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import javax.jcr.Node;

import org.ametys.cms.indexing.solr.SolrAclCacheUninfluentialObject;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;

/**
 * Class representing a cart container, backed by a JCR node.<br>
 */
@SolrAclCacheUninfluentialObject
public class CartContainer extends DefaultTraversableAmetysObject<CartContainerFactory>
{
    /**
     * Creates an {@link CartContainer}.
     * @param node the node backing this {@link AmetysObject}
     * @param parentPath the parentPath in the Ametys hierarchy
     * @param factory the DefaultAmetysObjectFactory which created the AmetysObject
     */
    public CartContainer(Node node, String parentPath, CartContainerFactory factory)
    {
        super(node, parentPath, factory);
    }
}
