/*
 *  Copyright 2013 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.cart;

import javax.jcr.Node;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.core.group.GroupManager;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.data.type.ModelItemTypeExtensionPoint;
import org.ametys.plugins.repository.jcr.DefaultAmetysObjectFactory;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.model.DefaultElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.exception.UnknownTypeException;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link AmetysObjectFactory} for handling {@link Cart}s.
 */
public class CartFactory extends DefaultAmetysObjectFactory
{
    /** JCR nodetype for cart */
    public static final String CART_NODETYPE = RepositoryConstants.NAMESPACE_PREFIX + ":cart";
    
    /** Group manager */
    protected GroupManager _groupManager;
    
    /** Content type extension point */
    protected ContentTypeExtensionPoint _cTypeEP;
    /** Helper for content types */
    protected ContentTypesHelper _contentTypesHelper;
    /** Extension point for content types */
    protected ContentTypeExtensionPoint _contentTypeEP;

    private Model _model;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _cTypeEP = (ContentTypeExtensionPoint) manager.lookup(ContentTypeExtensionPoint.ROLE);
        _contentTypesHelper = (ContentTypesHelper) manager.lookup(ContentTypesHelper.ROLE);
        _contentTypeEP = (ContentTypeExtensionPoint) manager.lookup(ContentTypeExtensionPoint.ROLE);
        _groupManager = (GroupManager) manager.lookup(GroupManager.ROLE);
    }
    
    @Override
    public Cart getAmetysObject(Node node, String parentPath) throws AmetysRepositoryException
    {
        return new Cart(node, parentPath, this);
    }
    
    AmetysObjectResolver getResolver()
    {
        return _resolver;
    }
    
    /**
     * Group manager getter.
     * @return The group manager
     */
    GroupManager _getGroupsManager()
    {
        return _groupManager;
    }
    
    /**
     * Getter for the content types helper
     * @return The helper for content types
     */
    ContentTypesHelper _getContentTypesHelper()
    {
        return _contentTypesHelper;
    }
    
    /**
     * Getter for the content types helper
     * @return The helper for content types
     */
    ContentTypeExtensionPoint _getContentTypeEP()
    {
        return _contentTypeEP;
    }

    /**
     * Retrieves the query model
     * @return the query model
     */
    public Model getModel()
    {
        if (_model == null)
        {
            _model = _createQueryModel();
        }
        return _model;
    }
    
    /**
     * Creates the query model
     * @return the created model
     * @throws AmetysRepositoryException if an error occurs.
     */
    protected Model _createQueryModel() throws AmetysRepositoryException
    {
        try
        {
            String role = ModelItemTypeExtensionPoint.ROLE_MODEL_AWARE_BASIC;

            return Model.of(Cart.class.getName(), Cart.class.getName(),
                    DefaultElementDefinition.of(Cart.TITLE, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.DESCRIPTION, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.DOCUMENTATION, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.CREATIONDATE, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.LASTMODIFICATIONDATE, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.AUTHOR, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.CONTRIBUTOR, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.CONTENT_CART_ELEMENTS, true, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.RESOURCE_CART_ELEMENTS, true, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    DefaultElementDefinition.of(Cart.QUERIES_FROM_DIRECTORY_CART_ELEMENTS, true, ModelItemTypeConstants.STRING_TYPE_ID, role),
                    RepeaterDefinition.of(Cart.QUERIES_CART_ELEMENTS, role,
                        DefaultElementDefinition.of(Cart.QUERY_ID_PROPERTY, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(Cart.QUERY_DESCRIPTION_PROPERTY, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(Cart.QUERY_AUTHOR_PROPERTY, false, org.ametys.cms.data.type.ModelItemTypeConstants.USER_ELEMENT_TYPE_ID, role),
                        DefaultElementDefinition.of(Cart.QUERY_TITLE_PROPERTY, false, ModelItemTypeConstants.STRING_TYPE_ID, role),
                        DefaultElementDefinition.of(Cart.QUERY_DATE_PROPERTY, false, ModelItemTypeConstants.DATETIME_TYPE_ID, role)));
        }
        catch (UnknownTypeException | BadItemTypeException | ServiceException e)
        {
            throw new AmetysRepositoryException("An error occurred while create the query model", e);
        }
    }
}
