/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.classified.ads;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.user.status.PersonalDataPolicy;
import org.ametys.core.user.status.UserStatusInfo;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.UserExpression;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ClassifiedAdsDataPolicy
extends AbstractLogEnabled
implements PersonalDataPolicy,
Serviceable {
    public static final String CLASSIFIED_ADS_CONTENT_TYPE = "org.ametys.plugins.classified.ads.Content.ads";
    protected ContentDAO _contentDAO;
    protected AmetysObjectResolver _resolver;
    private Period _retentionPeriod;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        Long config = (Long)Config.getInstance().getValue("classified-ads.data-policy.retention.period", false, null);
        this._retentionPeriod = config != null && config >= 0L ? Period.ofMonths(config.intValue()) : null;
    }

    public PersonalDataPolicy.AnonymizationResult process(UserStatusInfo userStatusInfo) {
        if (this._retentionPeriod == null) {
            return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
        }
        if (userStatusInfo.getMissingSinceDate().isBefore(ZonedDateTime.now().minus(this._retentionPeriod))) {
            AndExpression filter = new AndExpression(new Expression[0]);
            filter.add((Object)new UserExpression("creator", Expression.Operator.EQ, userStatusInfo.getUserIdentity()));
            filter.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{CLASSIFIED_ADS_CONTENT_TYPE}));
            String query = ContentQueryHelper.getContentXPathQuery((Expression)filter);
            try (AmetysObjectIterable contents = this._resolver.query(query);){
                if (contents.getSize() > 0L) {
                    this._contentDAO.forceDeleteContentsObj(contents.stream().toList(), null);
                    ForensicLogger.info((String)"data.policy.gdpr.remove.classified-ads", Map.of("handled", Long.toString(contents.getSize()), "identity", userStatusInfo.getUserIdentity()), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
                    PersonalDataPolicy.AnonymizationResult anonymizationResult = PersonalDataPolicy.AnonymizationResult.PROCESSED;
                    return anonymizationResult;
                }
                PersonalDataPolicy.AnonymizationResult anonymizationResult = PersonalDataPolicy.AnonymizationResult.NO_DATA;
                return anonymizationResult;
            }
        }
        return PersonalDataPolicy.AnonymizationResult.TOO_EARLY;
    }
}

