/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.classified.ads;

import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Map;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.trace.ForensicLogger;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.DateExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class DeleteClassifiedAdsSchedulable
extends AbstractStaticSchedulable {
    public static final String JOBDATAMAP_NB_MONTH = "nbMonth";
    public static final String CLASSIFIED_ADS_CONTENT_TYPE = "org.ametys.plugins.classified.ads.Content.ads";
    protected AmetysObjectResolver _resolver;
    protected ContentDAO _contentDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Long delay = (Long)jobDataMap.get((Object)"parameterValues#nbMonth");
        if (delay == null) {
            delay = (Long)Config.getInstance().getValue("classified-ads.conservation.delay", false, null);
        }
        if (delay == null || delay < 0L) {
            throw new IllegalArgumentException("The expiration delay must be positive");
        }
        ZonedDateTime expirationDate = ZonedDateTime.now().minus(Period.ofMonths(delay.intValue()));
        AndExpression filter = new AndExpression(new Expression[0]);
        filter.add((Object)new DateExpression("creationDate", Expression.Operator.LE, DateUtils.asDate((ZonedDateTime)expirationDate)));
        filter.add((Object)new ContentTypeExpression(Expression.Operator.EQ, new String[]{CLASSIFIED_ADS_CONTENT_TYPE}));
        String query = ContentQueryHelper.getContentXPathQuery((Expression)filter);
        try (AmetysObjectIterable contents = this._resolver.query(query);){
            this._contentDAO.forceDeleteContentsObj(contents.stream().toList(), null);
            ForensicLogger.info((String)"data.policy.classified-ads", Map.of("handled", Long.toString(contents.getSize())), (UserIdentity)UserPopulationDAO.SYSTEM_USER_IDENTITY);
        }
    }
}

