<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
	xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
    exclude-result-prefixes="docbook">

    <xsl:import href="plugin:cms://stylesheets/helper/common.xsl"/>
	<xsl:import href="view://stylesheets/io/docbook2fo.xsl" />

	<xsl:param name="contextPath" />
	<xsl:param name="siteName" />
	<xsl:param name="skin" />

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master master-name="page"
					page-width="210mm" page-height="297mm" margin-left="0cm"
					margin-right="0cm" margin-top="0cm" margin-bottom="0cm">
					<fo:region-body margin-top="3cm" margin-bottom="1cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
					<fo:region-before extent="0cm">
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
					<fo:region-after extent="0cm">
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
				</fo:simple-page-master>
			</fo:layout-master-set>
			
			<xsl:apply-templates />
		</fo:root>
	</xsl:template>
	
	<xsl:template name="xsl-region-before">
	</xsl:template>

	<xsl:template match="content">
        <fo:page-sequence master-reference="page">
            
            <xsl:call-template name="xsl-region-before"/>
            
            <fo:flow flow-name="xsl-region-body">
                <fo:block margin-left="1cm" margin-right="1cm">
                    <xsl:call-template name="main-body-block"/>
                    
                    <fo:block>
                        <xsl:call-template name="title-style">
                            <xsl:with-param name="level" select="2"/>
                        </xsl:call-template>
                        
                        <xsl:value-of select="metadata/title" />
                    </fo:block>
                </fo:block>
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
</xsl:stylesheet>
