/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.classified.ads;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.page.jcr.DefaultPage;
import org.ametys.web.sitemap.AbstractStaticSitemapIndicator;
import org.ametys.web.sitemap.SitemapTreeIndicator;

/**
 * {@link SitemapTreeIndicator} for classified ads root page
 */
public class ClassifiedAdsRootSitemapIndicator extends AbstractStaticSitemapIndicator implements Serviceable
{
    private static final String __CLASSIFIED_ADS_CONTENT_TYPE = "org.ametys.plugins.classified.ads.Content.ads";
    
    /** The UGC page handler */
    protected UGCPageHandler _ugcPageHandler;
    
    public void service(ServiceManager smanager) throws ServiceException
    {
        _ugcPageHandler = (UGCPageHandler) smanager.lookup(UGCPageHandler.ROLE);
    }

    public boolean matches(SitemapElement sitemapElement)
    {
        if (sitemapElement instanceof DefaultPage page)
        {
            return _ugcPageHandler.isUGCRootPage(page, __CLASSIFIED_ADS_CONTENT_TYPE);
        }
        return false;
    }
}
