/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.File;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.plugins.contentio.archive.AbstractArchiveSchedulable;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;

public class ExportArchiveSchedulable
extends AbstractArchiveSchedulable {
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        User user = this._getUser();
        String userEmail = null;
        String language = this._userLanguagesManager.getDefaultLanguage();
        if (user != null) {
            userEmail = user.getEmail();
            String userLanguage = user.getLanguage();
            language = (String)StringUtils.defaultIfBlank((CharSequence)userLanguage, (CharSequence)language);
        }
        File output = this._createFileOutput();
        this.getLogger().info("Exporting archive {} ...", (Object)output.getAbsolutePath());
        long t0 = System.currentTimeMillis();
        try {
            this._archiveHandler.export(output);
            this.getLogger().info("Archive {} exported without error in {} ms", (Object)output.getAbsolutePath(), (Object)(System.currentTimeMillis() - t0));
            String subject = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_MAIL_SUBJECT"), language);
            String body = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_MAIL_BODY"), language);
            this._sendMail(subject, body + " " + output.getCanonicalPath(), userEmail);
        }
        catch (Exception e) {
            FileUtils.deleteQuietly((File)output);
            String subject = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_MAILERROR_SUBJECT"), language);
            String body = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_MAILERROR_BODY"), language);
            this._sendMail(subject, body, userEmail);
            throw e;
        }
    }

    private File _createFileOutput() {
        String timestamp = DateTimeFormatter.ofPattern("uuuuMMddHHmmss").format(ZonedDateTime.now());
        Path parent = this._archiveHandler.getArchiveFolder();
        File output = parent.resolve("archive-" + timestamp + ".zip").toFile();
        return output;
    }
}

