/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.ManifestReaderWriter;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.contentio.archive.ResourcesArchiverHelper;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.slf4j.Logger;

public class ResourcesArchiver
extends AbstractLogEnabled
implements Archiver,
Serviceable {
    public static final String ID = "resources";
    private AmetysObjectResolver _resolver;
    private ResourcesArchiverHelper _resourcesArchiverHelper;
    private ManifestReaderWriter _manifestReaderWriter = new ResourcesArchiverManifestReaderWriter(this.getLogger());

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._resourcesArchiverHelper = (ResourcesArchiverHelper)((Object)manager.lookup(ResourcesArchiverHelper.ROLE));
    }

    @Override
    public ManifestReaderWriter getManifestReaderWriter() {
        return this._manifestReaderWriter;
    }

    @Override
    public void export(ZipOutputStream zos) throws IOException {
        Optional<JCRResourcesCollection> rootResources = this._rootResources();
        if (rootResources.isPresent()) {
            this._resourcesArchiverHelper.exportCollection((ResourceCollection)rootResources.get(), zos, "resources/");
        }
    }

    private Optional<JCRResourcesCollection> _rootResources() {
        try {
            return Optional.of((JCRResourcesCollection)this._resolver.resolveByPath("/ametys:resources"));
        }
        catch (UnknownAmetysObjectException e) {
            return Optional.empty();
        }
    }

    private void _deleteBeforePartialImport(JCRResourcesCollection rootResources) throws IOException {
        try {
            Node allResourcesNode = rootResources.getNode();
            Session session = allResourcesNode.getParent().getSession();
            allResourcesNode.remove();
            session.save();
        }
        catch (RepositoryException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Collection<String> managedPartialImports(Collection<String> partialImports) {
        return partialImports.contains(ID) ? Collections.singletonList(ID) : Collections.EMPTY_LIST;
    }

    @Override
    public ImportReport partialImport(Path zipPath, Collection<String> partialImports, Merger merger, boolean deleteBefore) throws IOException {
        Optional<JCRResourcesCollection> rootResources = this._rootResources();
        if (rootResources.isPresent()) {
            this._deleteBeforePartialImport(rootResources.get());
        }
        JCRAmetysObject root = (JCRAmetysObject)this._resolver.resolveByPath("/");
        Node parentOfRootResources = root.getNode();
        return this._resourcesArchiverHelper.importCollection("resources/", parentOfRootResources, zipPath, merger);
    }

    private static final class ResourcesArchiverManifestReaderWriter
    implements ManifestReaderWriter {
        private static final String __DATA = "resources";
        private Logger _logger;

        public ResourcesArchiverManifestReaderWriter(Logger logger) {
            this._logger = logger;
        }

        @Override
        public Object getData() {
            return "resources";
        }

        @Override
        public Stream<PartialImport> toPartialImports(Object data) {
            return Optional.ofNullable(data).filter(String.class::isInstance).map(String.class::cast).filter("resources"::equals).map(Stream::of).orElseGet(() -> {
                this._logger.warn("Unexpected manifest data '{}', we would expect '{}', the ZIP archive probably comes from a different version of Ametys.", data, (Object)"resources");
                return Stream.empty();
            }).map(resourcesStr -> PartialImport.of(resourcesStr, new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_RESOURCE_ARCHIVER_OPTION_ALL")));
        }
    }
}

