/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.contentio.export.sql.ExportManager;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

public class ContentExportSchedulable
extends AbstractStaticSchedulable {
    protected ExportManager _exportManager;
    protected I18nUtils _i18nTranslator;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._exportManager = (ExportManager)((Object)manager.lookup(ExportManager.ROLE));
        this._i18nTranslator = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        long time_0 = System.currentTimeMillis();
        try {
            this._exportManager.export();
            if (this.getLogger().isInfoEnabled()) {
                ArrayList<String> i18nParams = new ArrayList<String>();
                i18nParams.add(String.valueOf(System.currentTimeMillis() - time_0));
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_END", i18nParams)));
            }
            this._sendMail(false);
        }
        catch (Exception ex) {
            this._sendMail(true);
            throw ex;
        }
    }

    protected void _sendMail(boolean error) throws MessagingException, IOException {
        block2: {
            String language = this._userLanguagesManager.getDefaultLanguage();
            String subject = this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_REPORT_MAIL_SUBJECT"), language);
            String email = (String)Config.getInstance().getValue("org.ametys.plugins.contentio.content.export.admin.mail");
            String body = this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_REPORT_MAIL_BODY" + (error ? "_ERROR" : "")), language);
            try {
                SendMailHelper.newMail().withSubject(subject).withTextBody(body).withRecipient(email).sendMail();
            }
            catch (MessagingException e) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_SEND_MAIL_ERROR"), language), (Throwable)e);
            }
        }
    }
}

