/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.plugins.contentio.in.ContentImportException;
import org.ametys.plugins.contentio.in.ContentImporter;
import org.ametys.plugins.contentio.in.ContentImporterExtensionPoint;
import org.ametys.plugins.contentio.in.xml.XmlContentImporter;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.xml.dom.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ContentImportManager
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = ContentImportManager.class.getName();
    protected ContentImporterExtensionPoint _contentImportEP;
    protected DOMParser _domParser;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._contentImportEP = (ContentImporterExtensionPoint)((Object)serviceManager.lookup(ContentImporterExtensionPoint.ROLE));
        this._domParser = (DOMParser)serviceManager.lookup(DOMParser.ROLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImportResult importContents(File file) throws ContentImportException {
        String name = file.getName();
        if (!file.canRead()) throw new ContentImportException("The file " + name + " is not a regular file or can't be read.");
        if (!file.isFile()) {
            throw new ContentImportException("The file " + name + " is not a regular file or can't be read.");
        }
        try (FileInputStream is = new FileInputStream(file);){
            ContentImporter importer = this.getImporter(file);
            if (importer != null) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                Set<String> contentIds = importer.importContents(is, params);
                ImportResult importResult = new ImportResult(this, contentIds);
                return importResult;
            }
            ImportResult importResult = new ImportResult(this, false);
            return importResult;
        }
        catch (IOException e) {
            this.getLogger().error("IO error while importing a content from file {}", (Object)name, (Object)e);
            throw new ContentImportException("IO error while importing a content from file " + name, e);
        }
    }

    public ImportResult importContents(InputStream is, String name) throws ContentImportException {
        Object os;
        File tempFile = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)name)) {
                String baseName = FilenameUtils.getBaseName((String)name);
                String ext = FilenameUtils.getExtension((String)name);
                tempFile = File.createTempFile(baseName, ext, AmetysHomeHelper.getAmetysHomeTmp());
            } else {
                tempFile = File.createTempFile("content-import-", null, AmetysHomeHelper.getAmetysHomeTmp());
            }
            os = new FileOutputStream(tempFile);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                ((OutputStream)os).close();
            }
            os = this.importContents(tempFile);
        }
        catch (IOException e) {
            try {
                this.getLogger().error("IO error while importing a content from file {}", (Object)name, (Object)e);
                throw new ContentImportException("IO error while importing a content from file " + name, e);
            }
            catch (Throwable throwable) {
                FileUtils.deleteQuietly(tempFile);
                throw throwable;
            }
        }
        FileUtils.deleteQuietly((File)tempFile);
        return os;
    }

    protected ContentImporter getImporter(File file) throws IOException {
        String name = file.getName();
        HashMap<String, Object> importContext = new HashMap<String, Object>();
        for (ContentImporter importer : this._contentImportEP.getImportersByPriority()) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                if (!this.supports(importer, in, name, importContext)) continue;
                ContentImporter contentImporter = importer;
                return contentImporter;
            }
        }
        return null;
    }

    protected boolean supports(ContentImporter importer, BufferedInputStream in, String name, Map<String, Object> importContext) throws IOException {
        if (importer instanceof XmlContentImporter) {
            return this.supportsXml((XmlContentImporter)importer, in, importContext);
        }
        return importer.supports(in, name);
    }

    protected boolean supportsXml(XmlContentImporter importer, BufferedInputStream in, Map<String, Object> importContext) throws IOException {
        Document document = null;
        if (!importContext.containsKey("xml-document")) {
            try {
                document = this._domParser.parseDocument(new InputSource(in));
            }
            catch (Exception exception) {
                // empty catch block
            }
            importContext.put("xml-document", document);
        } else {
            document = (Document)importContext.get("xml-document");
        }
        if (document != null) {
            return importer.supports(document);
        }
        return false;
    }

    public class ImportResult {
        protected boolean _importerFound;
        protected Set<String> _importedContentIds;

        public ImportResult(ContentImportManager this$0, boolean importerFound) {
            this._importerFound = importerFound;
            this._importedContentIds = Collections.emptySet();
        }

        public ImportResult(ContentImportManager this$0, Collection<String> importedContentIds) {
            this._importerFound = true;
            this._importedContentIds = new HashSet<String>(importedContentIds);
        }

        public boolean isImporterFound() {
            return this._importerFound;
        }

        public void setImporterFound(boolean importerFound) {
            this._importerFound = importerFound;
        }

        public Set<String> getImportedContentIds() {
            return this._importedContentIds;
        }

        public void setImportedContentIds(Collection<String> importedContentIds) {
            this._importedContentIds = new HashSet<String>(importedContentIds);
        }
    }
}

