/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImportReportGenerator
extends ServiceableGenerator {
    protected AmetysObjectResolver _resolver;
    private ContentHelper _contentHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Map jsParameters = (Map)this.objectModel.get("parent-context");
        Boolean success = (Boolean)jsParameters.get("success");
        Collection contentIds = (Collection)jsParameters.get("contentIds");
        String baseUrl = (String)jsParameters.get("baseUrl");
        String error = (String)jsParameters.get("error");
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("baseUrl", baseUrl);
        attrs.addCDATAAttribute("success", success.toString());
        if (StringUtils.isNotEmpty((CharSequence)error)) {
            attrs.addCDATAAttribute("error", error);
        }
        this.contentHandler.startDocument();
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"import", (Attributes)attrs);
        if (contentIds != null) {
            for (String id : contentIds) {
                Content content = (Content)this._resolver.resolveById(id);
                AttributesImpl contentAttrs = new AttributesImpl();
                contentAttrs.addCDATAAttribute("id", id);
                contentAttrs.addCDATAAttribute("title", StringUtils.defaultString((String)this._contentHelper.getTitle(content)));
                XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"content", (Attributes)contentAttrs);
            }
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"import");
        this.contentHandler.endDocument();
    }
}

