/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.TransformerHandler;
import org.ametys.plugins.contentio.ContentImporterHelper;
import org.ametys.plugins.contentio.in.AbstractContentImporter;
import org.ametys.plugins.contentio.in.xml.XmlContentImporter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.dom.DOMParser;
import org.apache.excalibur.xml.sax.SAXParser;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractXmlContentImporter
extends AbstractContentImporter
implements XmlContentImporter {
    protected ServiceManager _manager;
    protected SourceResolver _srcResolver;
    protected DOMParser _domParser;
    protected XPathProcessor _xPathProcessor;
    protected XSLTProcessor _xsltProcessor;
    protected PrefixResolver _prefixResolver;
    protected TransformerHandler _xslTransformerHandler;
    protected String _xsl;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._manager = serviceManager;
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._domParser = (DOMParser)serviceManager.lookup(DOMParser.ROLE);
        this._xPathProcessor = (XPathProcessor)serviceManager.lookup(XPathProcessor.ROLE);
        this._xsltProcessor = (XSLTProcessor)serviceManager.lookup(XSLTProcessor.ROLE + "/xalan");
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configureXml(configuration.getChild("xml"));
    }

    protected void configureXml(Configuration configuration) throws ConfigurationException {
        this._xsl = configuration.getChild("xsl").getAttribute("src", null);
        this.configureNamespaces(configuration.getChild("namespaces"));
    }

    @Override
    protected void configureContentCreation(Configuration configuration) throws ConfigurationException {
        String typesStr = configuration.getChild("content-types").getValue("");
        this._contentTypes = StringUtils.split((String)typesStr, (String)", ");
        String mixins = configuration.getChild("mixins").getValue("");
        this._mixins = StringUtils.split((String)mixins, (String)", ");
        this._language = configuration.getChild("language").getValue("");
        this.configureWorkflow(configuration);
    }

    protected void configureNamespaces(Configuration configuration) throws ConfigurationException {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (Configuration nsConf : configuration.getChildren("namespace")) {
            String prefix = nsConf.getAttribute("prefix", "");
            String namespace = nsConf.getAttribute("uri");
            namespaces.put(prefix, namespace);
        }
        this._prefixResolver = new DefaultPrefixResolver(namespaces);
    }

    protected PrefixResolver getPrefixResolver() {
        return this._prefixResolver;
    }

    @Override
    public boolean supports(InputStream is, String name) throws IOException {
        try {
            Document doc = this._domParser.parseDocument(new InputSource(is));
            return this.supports(doc);
        }
        catch (SAXException e) {
            throw new IOException("Error parsing the document.", e);
        }
    }

    @Override
    public Set<String> importContents(InputStream is, Map<String, Object> params) throws IOException {
        Set<String> contentIds = new HashSet<String>();
        SAXParser saxParser = null;
        try {
            Document document = null;
            if (this._xsl == null) {
                document = this._domParser.parseDocument(new InputSource(is));
            } else {
                this.initializeXslTransformerHandler();
                DOMResult result = new DOMResult();
                this._xslTransformerHandler.setResult(result);
                saxParser = (SAXParser)this._manager.lookup(SAXParser.ROLE);
                saxParser.parse(new InputSource(is), (ContentHandler)this._xslTransformerHandler);
                Node node = result.getNode();
                if (node instanceof Document) {
                    document = (Document)node;
                }
            }
            if (document != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Importing contents from document:\n {}", (Object)ContentImporterHelper.serializeNode(document, true));
                }
                contentIds = this.importContents(document, params);
            }
        }
        catch (ServiceException e) {
            this.getLogger().error("Unable to get a SAX parser.", (Throwable)e);
            throw new IOException("Unable to get a SAX parser.", e);
        }
        catch (TransformerException | XSLTProcessorException | SAXException e) {
            this.getLogger().error("Error parsing the XML document.", e);
            throw new IOException("Error parsing the XML document.", e);
        }
        finally {
            this._manager.release(saxParser);
        }
        return contentIds;
    }

    protected abstract Set<String> importContents(Document var1, Map<String, Object> var2) throws IOException;

    protected void initializeXslTransformerHandler() throws IOException, XSLTProcessorException {
        if (this._xslTransformerHandler == null && StringUtils.isNotEmpty((CharSequence)this._xsl)) {
            Source xslSource = null;
            try {
                xslSource = this._srcResolver.resolveURI(this._xsl);
                this._xslTransformerHandler = this._xsltProcessor.getTransformerHandler(xslSource);
                Properties format = new Properties();
                format.put("method", "xml");
                format.put("indent", "no");
                format.put("encoding", "UTF-8");
                this._xslTransformerHandler.getTransformer().setOutputProperties(format);
            }
            finally {
                this._srcResolver.release(xslSource);
            }
        }
    }

    protected String getTextContent(Node node, String defaultValue) {
        return this.getTextContent(node, defaultValue, false);
    }

    protected String getTextContent(Node node, String defaultValue, boolean trim) {
        String value = defaultValue;
        if (node != null) {
            value = trim ? node.getTextContent().trim() : node.getTextContent();
        }
        return value;
    }

    protected String getAttributeValue(Element element, String name, String defaultValue) {
        return this.getAttributeValue(element, name, defaultValue, true);
    }

    protected String getAttributeValue(Element element, String name, String defaultValue, boolean trim) {
        String value = defaultValue;
        if (element != null) {
            value = element.getAttribute(name);
        }
        return value != null ? (trim ? value.trim() : value) : null;
    }

    protected static class DefaultPrefixResolver
    implements PrefixResolver {
        private Map<String, String> _namespaces;

        public DefaultPrefixResolver(Map<String, String> namespaces) {
            this._namespaces = new HashMap<String, String>(namespaces);
        }

        public String prefixToNamespace(String prefix) {
            return this._namespaces.get(prefix);
        }
    }
}

