/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SynchronizableContentsCollectionDataProvider
extends AbstractLogEnabled
implements ExternalizableDataProvider,
Component,
Serviceable {
    public static final String SCC_ID_CONTEXT_KEY = "sccId";
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    protected SynchronizableContentsCollectionHelper _sccHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)((Object)manager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._sccHelper = (SynchronizableContentsCollectionHelper)((Object)manager.lookup(SynchronizableContentsCollectionHelper.ROLE));
    }

    public Set<String> getExternalizableDataPaths(ModelAwareDataHolder dataHolder) {
        if (dataHolder instanceof Content) {
            Content content = (Content)dataHolder;
            return this._sccHelper.getSynchronizableCollectionIds(content).stream().map(this._synchronizableContentsCollectionDAO::getSynchronizableContentsCollection).filter(collection -> collection != null).map(collection -> this._getExternalizableDataPaths(dataHolder, (SynchronizableContentsCollection)collection)).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return Set.of();
    }

    public boolean isDataExternalizable(ModelAwareDataHolder dataHolder, ModelItem modelItem, Map<String, Object> context) {
        Set externalizableDataPaths = Optional.of(context).map(ctx -> ctx.get(SCC_ID_CONTEXT_KEY)).filter(String.class::isInstance).map(String.class::cast).map(this._synchronizableContentsCollectionDAO::getSynchronizableContentsCollection).map(col -> this._getExternalizableDataPaths(dataHolder, (SynchronizableContentsCollection)col)).orElseGet(() -> this.getExternalizableDataPaths(dataHolder));
        return externalizableDataPaths.contains(modelItem.getPath());
    }

    private Set<String> _getExternalizableDataPaths(ModelAwareDataHolder dataHolder, SynchronizableContentsCollection collection) {
        return dataHolder instanceof Content ? collection.getLocalAndExternalFields(this.buildParametersMap((Content)dataHolder)) : Set.of();
    }

    private Map<String, Object> buildParametersMap(Content content) {
        return Map.of("contentTypes", Arrays.asList(content.getTypes()));
    }
}

