/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.holder.ModifiableModelLessDataHolder;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;

public class SynchronizableContentsCollectionHelper
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = SynchronizableContentsCollectionHelper.class.getName();
    protected SynchronizableContentsCollectionDAO _sccDAO;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected CurrentUserProvider _currentUserProvider;
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sccDAO = (SynchronizableContentsCollectionDAO)((Object)smanager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
    }

    public SynchronizableContentsCollection getSCCFromModelId(String modelId) {
        SynchronizableContentsCollection collection = null;
        for (SynchronizableContentsCollection scc : this._sccDAO.getSynchronizableContentsCollections()) {
            if (!scc.getSynchronizeCollectionModelId().equals(modelId)) continue;
            collection = scc;
            break;
        }
        return collection;
    }

    public Map<String, Map<String, List<Object>>> organizeRemoteValuesByAttribute(Map<String, Map<String, Object>> searchResult, Map<String, List<String>> mapping) {
        LinkedHashMap<String, Map<String, List<Object>>> result = new LinkedHashMap<String, Map<String, List<Object>>>();
        for (String resultKey : searchResult.keySet()) {
            Map<String, Object> searchItem = searchResult.get(resultKey);
            HashMap contentResult = new HashMap();
            for (String attributeName : mapping.keySet()) {
                List<String> columns = mapping.get(attributeName);
                List values = columns.stream().map(searchItem::get).flatMap(o -> {
                    if (o instanceof Collection) {
                        return ((Collection)o).stream();
                    }
                    return Stream.of(o);
                }).filter(Objects::nonNull).collect(Collectors.toList());
                contentResult.put(attributeName, values);
            }
            result.put(resultKey, contentResult);
        }
        return result;
    }

    public void updateSCCProperty(Content content, String collectionId) {
        Set<String> collectionIds = this.getSynchronizableCollectionIds(content);
        if (collectionIds.add(collectionId)) {
            content.getInternalDataHolder().setValue("scc", (Object)collectionIds.toArray(new String[collectionIds.size()]));
        }
    }

    public void removeSCCProperty(Content content, String collectionId) {
        Set<String> collectionIds = this.getSynchronizableCollectionIds(content);
        if (collectionIds.remove(collectionId)) {
            content.getInternalDataHolder().setValue("scc", (Object)collectionIds.toArray(new String[collectionIds.size()]));
        }
    }

    public void updateLastSynchronizationProperties(Content content) {
        content.getInternalDataHolder().setValue("lastSynchronization", (Object)ZonedDateTime.now(), "datetime");
        content.getInternalDataHolder().setValue("lastSynchronizationUser", (Object)this._currentUserProvider.getUser(), "user");
    }

    public Set<String> getSynchronizableCollectionIds(Content content) throws AmetysRepositoryException {
        ModifiableModelLessDataHolder internalDataHolder = content.getInternalDataHolder();
        Set<String> collectionIds = new HashSet<String>();
        if (internalDataHolder.hasValue("scc")) {
            String[] existingCollectionIds = (String[])internalDataHolder.getValue("scc");
            collectionIds = Arrays.stream(existingCollectionIds).collect(Collectors.toSet());
        }
        return collectionIds;
    }

    public Expression getCollectionExpression(String collectionId) {
        ExpressionContext context = ExpressionContext.newInstance().withInternal(true);
        return new StringExpression("scc", Expression.Operator.EQ, collectionId, context);
    }

    public Map<String, Object> importContent(String collectionId, String id, Map<String, Object> additionalParameters) {
        if (StringUtils.isBlank((CharSequence)id)) {
            this.getLogger().warn("The synchronization code cannot be empty.");
            return Map.of("error", "noSyncCode");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Locale defaultLocale = additionalParameters.containsKey("language") ? LocaleUtils.toLocale((String)((String)additionalParameters.get("language"))) : null;
            HashSet contentsList = new HashSet();
            SynchronizableContentsCollection collection = this._sccDAO.getSynchronizableContentsCollection(collectionId);
            ModifiableContent existingContent = collection.getContent(null, id, true);
            if (existingContent == null) {
                List<ModifiableContent> contents = collection.importContent(id, additionalParameters, this.getLogger());
                for (ModifiableContent content : contents) {
                    HashMap<String, String> contentMap = new HashMap<String, String>();
                    contentMap.put("id", content.getId());
                    contentMap.put("title", content.getTitle(defaultLocale));
                    contentMap.put("lang", content.getLanguage());
                    contentsList.add(contentMap);
                }
                result.put("contents", contentsList);
                result.put("total", contents.size());
            } else {
                result.put("contents", ImmutableList.of((Object)ImmutableMap.of((Object)"id", (Object)existingContent.getId(), (Object)"title", (Object)existingContent.getTitle(defaultLocale), (Object)"lang", (Object)existingContent.getLanguage())));
                result.put("error", "alreadyImported");
            }
        }
        catch (Exception e) {
            String errorMessage = "An exception occured during import of the content '" + id + "' on SCC '" + collectionId + "'";
            this.getLogger().error(errorMessage, (Throwable)e);
            throw new IllegalStateException(errorMessage);
        }
        return result;
    }

    public boolean synchronizeContent(String collectionId, String contentId, String syncCode) {
        ModifiableContent content = (ModifiableContent)this._resolver.resolveById(contentId);
        boolean hasErrors = false;
        try {
            SynchronizableContentsCollection collection = this._sccDAO.getSynchronizableContentsCollection(collectionId);
            collection.updateSyncInformations(content, syncCode, this.getLogger());
            if (StringUtils.isBlank((CharSequence)syncCode)) {
                return false;
            }
            HashMap<String, Object> searchParameters = new HashMap<String, Object>();
            searchParameters.put(collection.getIdField(), syncCode);
            if (collection.getTotalCount(searchParameters, this.getLogger()) > 0) {
                collection.synchronizeContent(content, this.getLogger());
            } else {
                this.getLogger().warn("In the collection '{}', there is not content matching with the synchronization code '{}'.", (Object)collectionId, (Object)syncCode);
                hasErrors = true;
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occured while synchronizing the content '{}' with the synchronization code '{}' from the '{}' collection.", new Object[]{contentId, syncCode, collectionId, e});
            hasErrors = true;
        }
        return hasErrors;
    }

    public String getSyncCode(String contentId, String collectionId) {
        SynchronizableContentsCollection collection = this._sccDAO.getSynchronizableContentsCollection(collectionId);
        Content content = (Content)this._resolver.resolveById(contentId);
        String syncCode = null;
        if (content.hasValue(collection.getIdField())) {
            syncCode = (String)content.getValue(collection.getIdField());
        }
        return syncCode;
    }
}

