/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.rights;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.right.AbstractStaticRightAssignmentContext;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.ClientSideElementHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SynchronizeContentRightAssignmentContext
extends AbstractStaticRightAssignmentContext {
    public static final String ROOT_CONTEXT_PREFIX = "/synchronized-contents/";
    protected AmetysObjectResolver _resolver;
    protected SynchronizableContentsCollectionDAO _collectionsDAO;
    protected I18nUtils _i18nUtils;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._collectionsDAO = (SynchronizableContentsCollectionDAO)((Object)smanager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
    }

    public Object convertJSContext(Object context) {
        if (context instanceof String) {
            String stringContext = (String)context;
            if (stringContext.startsWith(ROOT_CONTEXT_PREFIX)) {
                return context;
            }
            return this._resolver.resolveById((String)context);
        }
        return null;
    }

    public String getContextIdentifier(Object context) {
        if (context instanceof Content) {
            return ((AmetysObject)context).getId();
        }
        return (String)context;
    }

    public Set<Object> getParentContexts(Object context) {
        if (context instanceof Content) {
            String[] collectionIds = (String[])((Content)context).getInternalDataHolder().getValue("scc");
            return Set.of(ROOT_CONTEXT_PREFIX + collectionIds[0]);
        }
        return null;
    }

    public List<Object> getRootContexts(Map<String, Object> contextParameters) {
        ArrayList<Object> rootContexts = new ArrayList<Object>();
        if (this.matchWorkspace(contextParameters)) {
            for (SynchronizableContentsCollection synchronizableContentsCollection : this._collectionsDAO.getSynchronizableContentsCollections()) {
                if (!synchronizableContentsCollection.handleRightAssignmentContext()) continue;
                rootContexts.add(ROOT_CONTEXT_PREFIX + synchronizableContentsCollection.getId());
            }
        }
        return rootContexts;
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> scripts = new ArrayList<ClientSideElement.Script>();
        List superScripts = super.getScripts(ignoreRights, contextParameters);
        if (superScripts != null && superScripts.size() == 1) {
            for (SynchronizableContentsCollection synchronizableContentsCollection : this._collectionsDAO.getSynchronizableContentsCollections()) {
                if (!synchronizableContentsCollection.handleRightAssignmentContext()) continue;
                ClientSideElement.Script script = ClientSideElementHelper.cloneScript((ClientSideElement.Script)((ClientSideElement.Script)superScripts.get(0)));
                script.getParameters().put("root-context", ROOT_CONTEXT_PREFIX + synchronizableContentsCollection.getId());
                script.getParameters().put("scc", synchronizableContentsCollection.getId());
                this._parametrizeValue(script, "label", synchronizableContentsCollection.getLabel());
                this._parametrizeValue(script, "radio-option-all-label", synchronizableContentsCollection.getLabel());
                this._parametrizeValue(script, "hint-all-contents", synchronizableContentsCollection.getLabel());
                this._parametrizeValue(script, "result-grid-mask-message", synchronizableContentsCollection.getLabel());
                scripts.add(script);
            }
        }
        return scripts;
    }

    private void _parametrizeValue(ClientSideElement.Script script, String key, I18nizableText i18nKey) {
        Object label = script.getParameters().get(key);
        if (label == null) {
            script.getParameters().put(key, i18nKey);
        } else if (label instanceof String) {
            script.getParameters().put(key, String.valueOf(label) + " " + this._i18nUtils.translate((I18nizable)i18nKey));
        } else if (label instanceof I18nizableText) {
            I18nizableText i18nLabel = (I18nizableText)label;
            if (i18nLabel.isI18n()) {
                if (i18nLabel.getParameters() != null) {
                    ArrayList<String> parameters = new ArrayList<String>(i18nLabel.getParameters());
                    parameters.add(this._i18nUtils.translate((I18nizable)i18nKey));
                    script.getParameters().put(key, new I18nizableText(i18nLabel.getCatalogue(), i18nLabel.getKey(), parameters));
                } else {
                    HashMap<String, I18nizableText> parametersMap = i18nLabel.getParameterMap() != null ? new HashMap<String, I18nizableText>(i18nLabel.getParameterMap()) : new HashMap();
                    parametersMap.put("collection", i18nKey);
                    script.getParameters().put(key, new I18nizableText(i18nLabel.getCatalogue(), i18nLabel.getKey(), parametersMap));
                }
            } else {
                script.getParameters().put(key, i18nLabel.getLabel() + " " + this._i18nUtils.translate((I18nizable)i18nKey));
            }
        }
    }
}

