/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.search;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.RibbonControlsManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.contentio.synchronize.search.SCCSearchModelConfiguration;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class SCCSearchToolHelper
implements Component,
Serviceable {
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    protected SynchronizableContentsCollectionHelper _synchronizableContentsCollectionHelper;
    protected CurrentUserProvider _currentUserProvider;
    protected RibbonControlsManager _ribbonControlsManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)((Object)manager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._synchronizableContentsCollectionHelper = (SynchronizableContentsCollectionHelper)((Object)manager.lookup(SynchronizableContentsCollectionHelper.ROLE));
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._ribbonControlsManager = (RibbonControlsManager)manager.lookup(RibbonControlsManager.ROLE);
    }

    @Callable(rights={"*"})
    public Map<String, Object> getSearchModelConfiguration(String collectionId) {
        SynchronizableContentsCollection collection = this._synchronizableContentsCollectionDAO.getSynchronizableContentsCollection(collectionId);
        SCCSearchModelConfiguration searchModelConfiguration = collection.getSearchModelConfiguration();
        return searchModelConfiguration.toJSON();
    }

    @Callable(rights={""})
    public Map<String, Object> importContent(String controllerId, String collectionId, String id, Map<String, Object> additionalParameters) {
        this._checkArgumentsAndRights(controllerId, collectionId);
        return this._synchronizableContentsCollectionHelper.importContent(collectionId, id, additionalParameters);
    }

    @Callable(rights={""})
    public String getSyncCode(String controllerId, String contentId, String collectionId) {
        this._checkArgumentsAndRights(controllerId, collectionId);
        return this._synchronizableContentsCollectionHelper.getSyncCode(contentId, collectionId);
    }

    private void _checkArgumentsAndRights(String controllerId, String collectionId) throws IllegalArgumentException, AccessDeniedException {
        if (StringUtils.isEmpty((CharSequence)controllerId)) {
            throw new IllegalArgumentException("User " + String.valueOf(this._currentUserProvider.getUser()) + " ' tried to import content from an empty controller for the collection '" + collectionId + "'.");
        }
        ClientSideElement controller = this._ribbonControlsManager.getExtension(controllerId);
        List scripts = controller.getScripts(false, new HashMap());
        String configuredCollectionId = scripts.stream().map(ClientSideElement.Script::getParameters).filter(params -> params.containsKey("sccModelId")).map(params -> params.get("sccModelId")).filter(String.class::isInstance).map(String.class::cast).findFirst().map(this._synchronizableContentsCollectionHelper::getSCCFromModelId).map(SynchronizableContentsCollection::getId).orElse(null);
        if (!collectionId.equals(configuredCollectionId)) {
            throw new IllegalArgumentException("User " + String.valueOf(this._currentUserProvider.getUser()) + " ' tried to import content from the controller '" + controllerId + "' that does not match the excepted controller for the collection '" + collectionId + "'.");
        }
    }
}

