/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton to import csv çontents as the children of the selected content
 * @private
 */
Ext.define('Ametys.plugins.contentio.SelectionAwareConfigurableImportCSVActions',{
    singleton: true,
    
    /**
     * This action imports simple contents from a CSV file
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    importCSVUnderSelectedParent: function (controller, additionalParams)
    {
        var additionalParams = additionalParams || {};
        var matchingTargets = controller.getMatchingTargets();
        if (matchingTargets.length == 1)
        {
            additionalParams["parentId"] = matchingTargets[0].getConfig()["parameters"]["id"];
        }
        
        this.importCSV(controller, additionalParams);
    },
    
    /**
     * This action imports simple contents from a CSV file
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    importCSV: function (controller, additionalParams)
    {
        var params = this._getContentTypeParameters(controller);
        if (additionalParams)
        {
            params = Ext.apply(params, additionalParams);
        }
    
        var config = Ext.apply(controller.getInitialConfig(), params);
                
        Ametys.plugins.contentio.ImportCSVActions.open(config);
    },
    
    _getContentTypeParameters: function (controller)
    {
        return {
            "content-type": controller.config.contentType,
            "create-action": controller.config.initWorkflowActionId,
            "edit-action": controller.config.editWorkflowActionId,
            "workflow-name": controller.config.workflowName
        };
    }
});