<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2014 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:escapeutils="org.apache.commons.lang3.StringEscapeUtils"
                extension-element-prefixes="escapeutils">

    <xsl:template match="ActionResult">
        <json>
            <xsl:choose>
                <xsl:when test="success = 'true'">
                    <xsl:text>{</xsl:text>
                        <xsl:text>"success": true,</xsl:text>
                        <xsl:text>"importedCount": "</xsl:text><xsl:value-of select="importedCount"/><xsl:text>",</xsl:text>
                        <xsl:text>"importedIds": "</xsl:text><xsl:value-of select="importedIds"/><xsl:text>"</xsl:text>
                    <xsl:text>}</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>{"success":false, "error": "</xsl:text><xsl:value-of select="error"/><xsl:text>", "message":"</xsl:text><xsl:value-of select="escapeutils:escapeEcmaScript(message)"/><xsl:text>"}</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </json>
    </xsl:template>
    
</xsl:stylesheet>
