/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.archive;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;

/**
 * {@link Enumerator} for listing available archives for import.
 */
public class ArchiveFileEnumerator implements Enumerator<String>, Serviceable
{
    private ArchiveHandler _archiveHandler;
    
    @Override 
    public void service(ServiceManager manager) throws ServiceException
    {
        _archiveHandler = (ArchiveHandler) manager.lookup(ArchiveHandler.ROLE);
    }
    
    @Override 
    public I18nizableText getEntry(String value) throws Exception
    {
        return _valueToLabel(value);
    }
    
    private I18nizableText _valueToLabel(String archiveName)
    {
        // Just display the archive name
        return new I18nizableText(archiveName);
    }

    @Override 
    public Map<String, I18nizableText> getEntries() throws Exception
    {
        return _archiveHandler.getArchiveFiles()
                .collect(Collectors.toMap(
                        Function.identity(), 
                        this::_valueToLabel));
    }
}
