/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.export.sql;

import java.util.HashMap;
import java.util.Map;

/**
 * Configuration object for the export
 */
public class ExportConfiguration
{
    private String _tablePrefix;
    private Map<String, Map<String, String>> _mappingSql;
    private Map<String, Map<String, String>> _reservedWords;
    private Map<String, String> _contentTypesToExport;
    private String _mappingPolicy; /** FULL, CAMELCASE or FIRSTCHAR*/
    private boolean _exportOnlyValidatedContent;
    private boolean _exportNoMultiValuedTable;
    private String _separator;
    
    /**
     * Constructor
     */
    public ExportConfiguration()
    {
        setMappingSql(new HashMap<>());
        setContentTypesToExport(new HashMap<>());
        _mappingPolicy = "FULL";
    }

    /**
     * Get the table prefix
     * @return table prefix
     */
    public String getTablePrefix()
    {
        return _tablePrefix;
    }

    /**
     * Set the table prefix
     * @param tablePrefix the table name prefix
     */
    public void setTablePrefix(String tablePrefix)
    {
        this._tablePrefix = tablePrefix;
    }

    
    /**
     * Get the sql mapping
     * @return the sql mapping
     */
    public Map<String, Map<String, String>> getMappingSql()
    {
        return _mappingSql;
    }

    /**
     * Set the sql mapping
     * @param mappingSql the sql mapping
     */
    public void setMappingSql(Map<String, Map<String, String>> mappingSql)
    {
        this._mappingSql = mappingSql;
    }

    /**
     * Get the content type to export
     * @return the content type to export
     */
    public Map<String, String> getContentTypesToExport()
    {
        return _contentTypesToExport;
    }

    /**
     * Set the content type to export
     * @param contentTypesToExport the map of content type to export
     */
    public void setContentTypesToExport(Map<String, String> contentTypesToExport)
    {
        this._contentTypesToExport = contentTypesToExport;
    }

    /**
     * Get the mapping policy
     * @return the mapping policy
     */
    public String getMappingPolicy()
    {
        return _mappingPolicy;
        
    }
    
    /**
     * Set the mapping policy
     * @param mappingPolicy the mapping policy
     */
    public void setMappingPolicy(String mappingPolicy)
    {
        this._mappingPolicy = mappingPolicy;
    }
    
    /**
     * Return true if we export only validated content
     * @return true if we export only validated content
     */
    public boolean exportOnlyValidatedContent()
    {
        return _exportOnlyValidatedContent;
    }
    
    /**
     * Set the parameter to export only validated content
     * @param onlyValidatedContent true if you want to export only validated content
     */
    public void setExportOnlyValidatedContent(boolean onlyValidatedContent)
    {
        this._exportOnlyValidatedContent = onlyValidatedContent;
    }
    
    /**
     * Return true if we export no multivalued table
     * @return true if we export no multivalued table
     */
    public boolean exportNoMultiValuedTable()
    {
        return _exportNoMultiValuedTable;
    }
    
    /**
     * Set the parameter to export no multivalued table
     * @param exportNoMultiValuedTable true if you want to export no multivalued table
     */
    public void setExportNoMultiValuedTable(boolean exportNoMultiValuedTable)
    {
        this._exportNoMultiValuedTable = exportNoMultiValuedTable;
    }
    
    /**
     * Get the separator for multivalued data
     * @return the separator
     */
    public String getSeparator()
    {
        return _separator;
    }
    
    /**
     * Set the separator for multivalued data
     * @param separator the separator
     */
    public void setSeparator(String separator)
    {
        this._separator = separator;
    }
    
    /**
     * Get the map of reserved words
     * @return the map of reserved words
     */
    public Map<String, Map<String, String>> getReservedWords()
    {
        return _reservedWords;
        
    }
    
    /**
     * Set the map of reserved words
     * @param reservedWords the map of reserved words
     */
    public void setReservedWords(Map<String, Map<String, String>> reservedWords)
    {
        this._reservedWords = reservedWords;
    }
    
}
