/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentPrioritizableExtensionPoint;

/**
 * Extension point for {@link ContentImporter}s.
 */
public class ContentImporterExtensionPoint extends AbstractThreadSafeComponentPrioritizableExtensionPoint<ContentImporter>
{
    /** Avalon Role */
    public static final String ROLE = ContentImporterExtensionPoint.class.getName();
    
    /** The importers, sorted by priority. */
    protected List<ContentImporter> _importersByPriority;
    
    /**
     * Get the importer IDs, sorted by ascending priority.
     * @return the importer IDs, sorted by ascending priority.
     */
    public List<ContentImporter> getImportersByPriority()
    {
        // On the first call, resolve the extensions in a list, they are already sorted.
        if (_importersByPriority == null)
        {
            _importersByPriority = getExtensionsIds()
                    .stream()
                    .map(this::getExtension)
                    .collect(Collectors.toList());
        }
        
        // Return the 
        return Collections.unmodifiableList(_importersByPriority);
    }
}
