/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;

/**
 * Generates the report of a content import.
 */
public class ImportReportGenerator extends ServiceableGenerator
{
    
    /** The AmetysObject resolver. */
    protected AmetysObjectResolver _resolver;
    private ContentHelper _contentHelper;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _resolver = (AmetysObjectResolver) serviceManager.lookup(AmetysObjectResolver.ROLE);
        _contentHelper = (ContentHelper) serviceManager.lookup(ContentHelper.ROLE);
    }
    
    @Override
    public void generate() throws IOException, SAXException, ProcessingException
    {
        @SuppressWarnings("unchecked")
        Map<String, Object> jsParameters = (Map<String, Object>) objectModel.get(ObjectModelHelper.PARENT_CONTEXT);
        Boolean success = (Boolean) jsParameters.get("success");
        @SuppressWarnings("unchecked")
        Collection<String> contentIds = (Collection<String>) jsParameters.get("contentIds");
        String baseUrl = (String) jsParameters.get("baseUrl");
        String error = (String) jsParameters.get("error");
        
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("baseUrl", baseUrl);
        attrs.addCDATAAttribute("success", success.toString());
        if (StringUtils.isNotEmpty(error))
        {
            attrs.addCDATAAttribute("error", error);
        }
        
        contentHandler.startDocument();
        XMLUtils.startElement(contentHandler, "import", attrs);
        
        if (contentIds != null)
        {
            for (String id : contentIds)
            {
                Content content = _resolver.resolveById(id);
                
                AttributesImpl contentAttrs = new AttributesImpl();
                
                contentAttrs.addCDATAAttribute("id", id);
                contentAttrs.addCDATAAttribute("title", StringUtils.defaultString(_contentHelper.getTitle(content)));
                XMLUtils.createElement(contentHandler, "content", contentAttrs);
            }
        }
        
        XMLUtils.endElement(contentHandler, "import");
        contentHandler.endDocument();
    }
    
}
