/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.properties.section.technical;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.properties.section.technical.AbstractTechnicalItem;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.core.user.UserHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.model.type.DataContext;

/**
 * Technical zone item to display synchronization informations.
 */
public class ContentSCCItem extends AbstractTechnicalItem implements Serviceable
{
    private SynchronizableContentsCollectionHelper _sccHelper;
    private UserHelper _userHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _sccHelper = (SynchronizableContentsCollectionHelper) manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        _userHelper = (UserHelper) manager.lookup(UserHelper.ROLE);
    }
    
    public boolean supports(AmetysObject ametysObject)
    {
        return ametysObject instanceof Content content && !_sccHelper.getSynchronizableCollectionIds(content).isEmpty();
    }
    
    public Map<String, Object> buildData(AmetysObject ametysObject)
    {
        Map<String, Object> resultMap = new LinkedHashMap<>();
        
        Content content = (Content) ametysObject;
        DataContext dataContext = DataContext.newInstance().withEmptyValues(false);

        resultMap.put("scc", content.dataToJSON(SynchronizableContentsCollection.COLLECTION_ID_DATA_NAME, dataContext));
        
        Map<String, Object> data = new HashMap<>();
        data.put("date", content.getValue(SynchronizableContentsCollection.LAST_SYNCHRONIZATION_DATA_NAME));
        data.put("user", _userHelper.user2json(content.<UserIdentity>getValue(SynchronizableContentsCollection.LAST_SYNCHRONIZATION_USER_DATA_NAME), true));
        resultMap.put("lastSynchronization", data);
        
        return resultMap;
    }
}
