/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import org.ametys.cms.data.holder.DataHolderElementDefinitionParser;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;

/**
 * Class for parsing parameters of a {@link SynchronizableContentsCollectionModel}
 */
public class SynchronizableContentsCollectionModelParameterParser extends DataHolderElementDefinitionParser
{
    /**
     * Creates a SCC parameter definition parser
     * @param sccParameterTypeEP the extension point to use to get available element types
     * @param disableConditionsManager the disable conditions component manager
     * @param enumeratorManager The manager for enumeration
     * @param validatorManager The manager for validation
     */
    public SynchronizableContentsCollectionModelParameterParser(ModelItemTypeExtensionPoint sccParameterTypeEP, ThreadSafeComponentManager<DisableConditions> disableConditionsManager, ThreadSafeComponentManager<Enumerator> enumeratorManager, ThreadSafeComponentManager<Validator> validatorManager)
    {
        super(sccParameterTypeEP, disableConditionsManager, enumeratorManager, validatorManager);
    }
    
    @Override
    protected String _getNameConfigurationAttribute()
    {
        return "id";
    }
}
