/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.Mergers;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.apache.cocoon.components.xslt.TraxErrorListener;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.jackrabbit.commons.xml.ParsingContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class IgnoreMergerHelper {
    private static final Logger __LOGGER = LoggerFactory.getLogger((String)IgnoreMergerHelper.class.getPackageName());
    private static final org.apache.avalon.framework.logger.Logger __AVALON_LOGGER = new SLF4JLoggerAdapter(__LOGGER);
    private static Map<Thread, Session> __SESSIONS_BY_REQUEST = new ConcurrentHashMap<Thread, Session>();

    private IgnoreMergerHelper() {
    }

    public static boolean uuidIsNotPresent(String nodeUuid) {
        if (StringUtils.isBlank((CharSequence)nodeUuid)) {
            return true;
        }
        try {
            Session session = __SESSIONS_BY_REQUEST.get(Thread.currentThread());
            Node node = session.getNodeByIdentifier(nodeUuid);
            Objects.requireNonNull(node, "Node cannot be null.");
            __LOGGER.debug("IgnoreMergerHelper#uuidIsNotPresent is called for argument '{}'. A node with this uuid was found. Returned result is false.", (Object)nodeUuid);
            return false;
        }
        catch (ItemNotFoundException e) {
            __LOGGER.debug("IgnoreMergerHelper#uuidIsNotPresent is called for argument '{}'. No node was found with this uuid. Returned result is true.", (Object)nodeUuid);
            return true;
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException((Throwable)e);
        }
    }

    static void jcrImportXml(Session session, String parentAbsPath, InputStream in, int importUuidBehavior, Mergers mergers) throws RepositoryException, IOException {
        ContentHandler importContentHandler = session.getImportContentHandler(parentAbsPath, importUuidBehavior);
        Thread currentThread = Thread.currentThread();
        try {
            __SESSIONS_BY_REQUEST.put(currentThread, session);
            TransformerHandler filteringContentHandler = IgnoreMergerHelper._sendFilteredSaxEvents(importContentHandler, mergers);
            IgnoreMergerHelper._sendSaxEventsFromInputStream(in, filteringContentHandler);
        }
        catch (TransformerException | SAXException e) {
            throw new IOException(e);
        }
        finally {
            __SESSIONS_BY_REQUEST.remove(currentThread);
        }
    }

    private static TransformerHandler _sendFilteredSaxEvents(ContentHandler receiverContentHandler, Mergers mergers) throws IOException, TransformerConfigurationException {
        Source xsltSource = null;
        try {
            TransformerHandler transformerHandler;
            block10: {
                xsltSource = mergers._sourceResolver.resolveURI("plugin:contentio://stylesheets/archive/ignore-merger-helper.xsl");
                InputStream inputStream = xsltSource.getInputStream();
                try {
                    StreamSource xsltStreamSource = new StreamSource(inputStream);
                    SAXTransformerFactory saxTransformerFactory = Archivers.getSaxTransformerFactory();
                    Templates xsltTemplates = saxTransformerFactory.newTemplates(xsltStreamSource);
                    TransformerHandler filteringTransformerHandler = saxTransformerFactory.newTransformerHandler(xsltTemplates);
                    TraxErrorListener errorListener = new TraxErrorListener(__AVALON_LOGGER, xsltSource.getURI());
                    filteringTransformerHandler.getTransformer().setErrorListener((ErrorListener)errorListener);
                    filteringTransformerHandler.setResult(new SAXResult(receiverContentHandler));
                    transformerHandler = filteringTransformerHandler;
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return transformerHandler;
        }
        finally {
            if (xsltSource != null) {
                mergers._sourceResolver.release(xsltSource);
            }
        }
    }

    private static void _sendSaxEventsFromInputStream(InputStream in, ContentHandler wrappedContentHandler) throws SAXException, IOException {
        ParsingContentHandler parsingContentHandler = new ParsingContentHandler(wrappedContentHandler);
        parsingContentHandler.parse(in);
    }
}

