/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.csv;

import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.type.BaseMultilingualStringElementType;
import org.ametys.cms.data.type.impl.MultilingualStringRepositoryElementType;
import org.ametys.cms.indexing.solr.SolrIndexHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ModifiableWorkflowAwareContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.cms.workflow.CreateContentFunction;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.csv.SynchronizeModeEnumerator;
import org.ametys.plugins.contentio.in.ContentImportException;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.group.ModelAwareRepeater;
import org.ametys.plugins.repository.data.holder.group.Repeater;
import org.ametys.plugins.repository.data.holder.group.RepeaterEntry;
import org.ametys.plugins.repository.data.holder.values.SynchronizableRepeater;
import org.ametys.plugins.repository.data.holder.values.SynchronizableValue;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.ametys.plugins.repository.metadata.MultilingualStringHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.ExpressionContext;
import org.ametys.plugins.repository.query.expression.MultilingualStringExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewElementAccessor;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.supercsv.io.ICsvListReader;
import org.supercsv.util.Util;

public class CSVImporter
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = CSVImporter.class.getName();
    public static final String RESULT_CONTENT_IDS = "contentIds";
    public static final String RESULT_NB_ERRORS = "nbErrors";
    public static final String RESULT_NB_WARNINGS = "nbWarnings";
    private ContentWorkflowHelper _contentWorkflowHelper;
    private ContentTypeExtensionPoint _contentTypeEP;
    private AmetysObjectResolver _resolver;
    private I18nUtils _i18nUtils;
    private SolrIndexHelper _solrIndexHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)smanager.lookup(ContentWorkflowHelper.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._solrIndexHelper = (SolrIndexHelper)smanager.lookup(SolrIndexHelper.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importContentsFromCSV(Map<String, Object> mapping, View view, ContentType contentType, ICsvListReader listReader, int createAction, int editAction, String workflowName, String language, SynchronizeModeEnumerator.ImportMode importMode, Optional<? extends Content> parentContent, Map<String, Object> additionalTransientVars) throws IOException {
        try {
            this._solrIndexHelper.pauseSolrCommitForEvents(this._getIndexationEvents());
            ArrayList<String> contentIds = new ArrayList<String>();
            String[] columns = listReader.getHeader(true);
            int nbErrors = 0;
            int nbWarnings = 0;
            List row = null;
            while ((row = listReader.read()) != null) {
                try {
                    if (listReader.length() != columns.length) {
                        this.getLogger().error("[{}] Import from CSV file: content skipped because of invalid row: {}", (Object)contentType.getId(), (Object)row);
                        ++nbErrors;
                        continue;
                    }
                    HashMap<String, String> rowMap = new HashMap<String, String>();
                    Util.filterListToMap(rowMap, (String[])columns, (List)row);
                    ArrayList<ViewItem> errors = new ArrayList<ViewItem>();
                    SynchronizeResult synchronizeResult = this.processContent(view, rowMap, contentType, mapping, createAction, editAction, workflowName, language, errors, importMode, parentContent, additionalTransientVars);
                    Optional<ModifiableWorkflowAwareContent> content = synchronizeResult.content();
                    if (content.isPresent() && (importMode != SynchronizeModeEnumerator.ImportMode.CREATE_ONLY || synchronizeResult.isCreated())) {
                        contentIds.add(content.get().getId());
                    }
                    if (errors.isEmpty()) continue;
                    ++nbWarnings;
                }
                catch (Exception e) {
                    ++nbErrors;
                    this.getLogger().error("[{}] Import from CSV file: error importing the content on line {}", new Object[]{contentType.getId(), listReader.getLineNumber(), e});
                }
            }
            HashMap<String, Object> results = new HashMap<String, Object>();
            results.put(RESULT_CONTENT_IDS, contentIds);
            results.put(RESULT_NB_ERRORS, nbErrors);
            results.put(RESULT_NB_WARNINGS, nbWarnings);
            HashMap<String, Object> hashMap = results;
            return hashMap;
        }
        finally {
            this._solrIndexHelper.restartSolrCommitForEvents(this._getIndexationEvents());
        }
    }

    private String[] _getIndexationEvents() {
        return new String[]{"content.added", "content.modified", "content.workflow.changed", "content.validated"};
    }

    protected SynchronizeResult processContent(View view, Map<String, String> row, ContentType contentType, Map<String, Object> mapping, int createAction, int editAction, String workflowName, String language, List<ViewItem> errors, SynchronizeModeEnumerator.ImportMode importMode, Optional<? extends Content> parentContent, Map<String, Object> additionalTransientVars) throws Exception {
        List attributeIdNames = (List)mapping.get("id");
        Map mappingValues = (Map)mapping.get("values");
        SynchronizeResult synchronizeResult = this._synchronizeContent(row, contentType, view, attributeIdNames, mappingValues, createAction, editAction, workflowName, language, errors, importMode, parentContent, additionalTransientVars);
        return synchronizeResult;
    }

    private void _editContent(int editAction, View view, Map<String, Object> values, ModifiableWorkflowAwareContent content) throws WorkflowException {
        Collection viewItemsDiff = content.getDifferences((ViewItemAccessor)view, values);
        if (!viewItemsDiff.isEmpty()) {
            this._contentWorkflowHelper.editContent((WorkflowAwareContent)content, values, editAction, View.of((ModelItem[])((ModelItem[])viewItemsDiff.toArray(ModelItem[]::new))));
        }
    }

    private Object _getValue(Optional<? extends Content> parentContent, ViewItem viewItem, Map<String, Object> mapping, Map<String, String> row, int createAction, int editAction, String language, List<ViewItem> errors, String prefix, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) throws Exception {
        if (viewItem instanceof ViewElement) {
            ViewElement viewElement = (ViewElement)viewItem;
            ElementDefinition elementDefinition = viewElement.getDefinition();
            if (elementDefinition instanceof ContentAttributeDefinition) {
                ContentAttributeDefinition contentAttributeDefinition = (ContentAttributeDefinition)elementDefinition;
                if (viewElement instanceof ViewElementAccessor) {
                    ViewElementAccessor viewElementAccessor = (ViewElementAccessor)viewElement;
                    return this._getContentAttributeDefinitionValues(parentContent, mapping, row, createAction, editAction, language, viewElementAccessor, contentAttributeDefinition, errors, importMode, additionalTransientVars);
                }
            }
            return this._getAttributeDefinitionValues(parentContent, mapping, row, elementDefinition, language, prefix);
        }
        if (viewItem instanceof ModelViewItemGroup) {
            ModelViewItemGroup modelViewItemGroup = (ModelViewItemGroup)viewItem;
            List children = modelViewItemGroup.getViewItems();
            Map nestedMap = (Map)mapping.get(viewItem.getName());
            Map nestedMapValues = (Map)nestedMap.get("values");
            if ("repeater".equals(modelViewItemGroup.getDefinition().getType().getId())) {
                return this._getRepeaterValues(parentContent, modelViewItemGroup, row, createAction, editAction, language, children, nestedMap, errors, prefix, importMode, additionalTransientVars);
            }
            return this._getCompositeValues(parentContent, viewItem, row, createAction, editAction, language, children, nestedMapValues, errors, prefix, importMode, additionalTransientVars);
        }
        errors.add(viewItem);
        throw new RuntimeException("Import from CSV file: unsupported type of ViewItem for view: " + viewItem.getName());
    }

    private Map<String, Object> _getCompositeValues(Optional<? extends Content> parentContent, ViewItem viewItem, Map<String, String> row, int createAction, int editAction, String language, List<ViewItem> children, Map<String, Object> nestedMapValues, List<ViewItem> errors, String prefix, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) {
        HashMap<String, Object> compositeValues = new HashMap<String, Object>();
        for (ViewItem child : children) {
            try {
                compositeValues.put(child.getName(), this._getValue(parentContent, child, nestedMapValues, row, createAction, editAction, language, errors, prefix + viewItem.getName() + "/", importMode, additionalTransientVars));
            }
            catch (Exception e) {
                errors.add(viewItem);
                this.getLogger().error("Import from CSV file: error while trying to get values for view: {}", (Object)viewItem.getName(), (Object)e);
            }
        }
        return compositeValues;
    }

    private SynchronizableRepeater _getRepeaterValues(Optional<? extends Content> parentContent, ModelViewItemGroup viewItem, Map<String, String> row, int createAction, int editAction, String language, List<ViewItem> children, Map<String, Object> nestedMap, List<ViewItem> errors, String prefix, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) {
        Map mappingValues = (Map)nestedMap.get("values");
        List<String> attributeIdNames = nestedMap.getOrDefault("id", List.of());
        HashMap<String, Object> repeaterValues = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> repeaterValuesList = new ArrayList<HashMap<String, Object>>();
        List<Object> indexList = new ArrayList();
        Optional<ModelAwareRepeater> repeater = parentContent.map(p -> p.getRepeater(prefix + viewItem.getName()));
        if (repeater.isPresent() && !attributeIdNames.isEmpty() && this._allAttributesFilled(mappingValues, attributeIdNames)) {
            indexList = repeater.get().getEntries().stream().filter(entry -> attributeIdNames.stream().allMatch(attributeName -> {
                Object entryValue = entry.getValue(attributeName);
                Object rowValue = Optional.of(attributeName).map(mappingValues::get).map(String.class::cast).map(row::get).orElse(null);
                return Optional.of(attributeName).map(arg_0 -> ((ModelViewItemGroup)viewItem).getModelViewItem(arg_0)).map(ViewElement.class::cast).map(ViewElement::getDefinition).map(ElementDefinition::getType).map(def -> def.castValue(rowValue)).map(value -> value.equals(entryValue)).orElse(false);
            })).map(RepeaterEntry::getPosition).collect(Collectors.toList());
        }
        Integer rowIndex = indexList.isEmpty() ? repeater.map(Repeater::getSize).orElse(1) : (Integer)indexList.get(0);
        for (ViewItem child : children) {
            try {
                Object entryValues = this._getValue(parentContent, child, mappingValues, row, createAction, editAction, language, errors, prefix + viewItem.getName() + "[" + rowIndex + "]/", importMode, additionalTransientVars);
                if (entryValues == null) continue;
                repeaterValues.put(child.getName(), entryValues);
            }
            catch (Exception e) {
                errors.add((ViewItem)viewItem);
                this.getLogger().error("Import from CSV file: error while trying to get values for view: {}", (Object)viewItem.getName(), (Object)e);
            }
        }
        repeaterValuesList.add(repeaterValues);
        if (indexList.isEmpty()) {
            return SynchronizableRepeater.appendOrRemove(repeaterValuesList, Set.of());
        }
        if (indexList.size() > 1) {
            errors.add((ViewItem)viewItem);
        }
        return SynchronizableRepeater.replace(repeaterValuesList, List.of(rowIndex));
    }

    private Object _getContentAttributeDefinitionValues(Optional<? extends Content> parentContent, Map<String, Object> mapping, Map<String, String> row, int createAction, int editAction, String language, ViewElementAccessor viewElementAccessor, ContentAttributeDefinition contentAttributeDefinition, List<ViewItem> errors, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) throws Exception {
        List attributeIdNames;
        String contentTypeId = contentAttributeDefinition.getContentTypeId();
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        Map nestedMap = (Map)mapping.get(viewElementAccessor.getName());
        Map mappingValues = (Map)nestedMap.get("values");
        if (this._allAttributesFilled(mappingValues, attributeIdNames = (List)nestedMap.get("id"))) {
            View view = new View();
            view.addViewItems(viewElementAccessor.getViewItems());
            SynchronizeResult synchronizeResult = this._synchronizeContent(row, contentType, view, attributeIdNames, mappingValues, createAction, editAction, null, language, errors, importMode, parentContent, additionalTransientVars);
            Optional<ModifiableWorkflowAwareContent> attachedContent = synchronizeResult.content();
            if (synchronizeResult.hasKey && attachedContent.isEmpty() && importMode == SynchronizeModeEnumerator.ImportMode.UPDATE_ONLY) {
                errors.add((ViewItem)viewElementAccessor);
            }
            if (attachedContent.isPresent() && contentAttributeDefinition.isMultiple()) {
                Optional<ContentValue[]> multipleContents = parentContent.map(c -> (ContentValue[])c.getValue(contentAttributeDefinition.getPath()));
                if (!this._containsContent(attachedContent.get(), multipleContents)) {
                    SynchronizableValue syncValue = new SynchronizableValue(List.of(attachedContent.get()));
                    syncValue.setMode(SynchronizableValue.Mode.APPEND);
                    return syncValue;
                }
                if (multipleContents.isPresent()) {
                    SynchronizableValue syncValue = new SynchronizableValue(Arrays.asList(multipleContents.get()));
                    syncValue.setMode(SynchronizableValue.Mode.REPLACE);
                    return syncValue;
                }
            } else {
                return attachedContent.orElse(null);
            }
        }
        return null;
    }

    private boolean _containsContent(ModifiableWorkflowAwareContent attachedContent, Optional<ContentValue[]> multipleContents) {
        return multipleContents.map(Arrays::stream).orElseGet(Stream::empty).map(ContentValue::getContentId).anyMatch(valueFromContent -> valueFromContent.equals(attachedContent.getId()));
    }

    private Object _getAttributeDefinitionValues(Optional<? extends Content> parentContent, Map<String, Object> mapping, Map<String, String> row, ElementDefinition elementDefinition, String language, String prefix) {
        Object value;
        ElementType elementType = elementDefinition.getType();
        String elementName = elementDefinition.getName();
        String elementColumn = (String)mapping.get(elementName);
        String valueAsString = row.get(elementColumn);
        if (elementType instanceof BaseMultilingualStringElementType && !MultilingualStringHelper.matchesMultilingualStringPattern((String)valueAsString)) {
            MultilingualString multilingualString = new MultilingualString();
            multilingualString.add(LocaleUtils.toLocale((String)language), valueAsString);
            value = multilingualString;
        } else {
            value = elementType.castValue((Object)valueAsString);
        }
        if (elementDefinition.isMultiple()) {
            String pathWithIndex = prefix + elementDefinition.getName();
            Optional<Object[]> values = parentContent.map(c -> (Object[])c.getValue(pathWithIndex));
            if (!this._containsValue(value, parentContent.map(c -> (Object[])c.getValue(pathWithIndex)))) {
                SynchronizableValue syncValue = new SynchronizableValue(value != null ? List.of(value) : List.of());
                syncValue.setMode(SynchronizableValue.Mode.APPEND);
                return syncValue;
            }
            if (values.isPresent()) {
                SynchronizableValue syncValue = new SynchronizableValue(Arrays.asList(values.get()));
                syncValue.setMode(SynchronizableValue.Mode.REPLACE);
                return syncValue;
            }
        } else {
            return value;
        }
        return null;
    }

    private boolean _containsValue(Object value, Optional<Object[]> multipleValues) {
        return multipleValues.map(Arrays::stream).orElseGet(Stream::empty).anyMatch(valueFromContent -> valueFromContent.equals(value));
    }

    private SynchronizeResult _synchronizeContent(Map<String, String> row, ContentType contentType, View view, List<String> attributeIdNames, Map<String, Object> mappingValues, int createAction, int editAction, String workflowName, String language, List<ViewItem> errors, SynchronizeModeEnumerator.ImportMode importMode, Optional<? extends Content> parentContent, Map<String, Object> additionalTransientVars) throws Exception {
        SynchronizeResult synchronizeResult = this._getOrCreateContent(mappingValues, row, contentType, Optional.ofNullable(workflowName), createAction, language, attributeIdNames, parentContent, importMode, additionalTransientVars);
        Optional<ModifiableWorkflowAwareContent> content = synchronizeResult.content();
        if (importMode == SynchronizeModeEnumerator.ImportMode.CREATE_ONLY && !synchronizeResult.isCreated() || importMode == SynchronizeModeEnumerator.ImportMode.UPDATE_ONLY && content.isEmpty()) {
            return synchronizeResult;
        }
        Map<String, Object> values = this._getValues(content, row, view, mappingValues, createAction, editAction, language, errors, importMode, additionalTransientVars);
        if (!values.isEmpty()) {
            if (content.isEmpty()) {
                throw new ContentImportException("Can't create and fill content of content type '" + contentType.getId() + "' and following values '" + String.valueOf(values) + "' : at least one of those identifiers is null : " + String.valueOf(attributeIdNames));
            }
            try {
                this._editContent(editAction, view, values, content.get());
            }
            catch (WorkflowException e) {
                errors.addAll(view.getViewItems());
                this.getLogger().error("[{}] Import from CSV file: error editing the content [{}] after import, some values have not been set", new Object[]{contentType.getId(), content.get().getId(), e});
            }
        }
        return synchronizeResult;
    }

    protected List<Expression> additionalExpressionToRetrieveContent(Map<String, Object> mapping, Map<String, String> row, ContentType contentType, Optional<? extends Content> parentContent, Map<String, Object> additionalTransientVars, List<String> valuesUsedAsIds) {
        return List.of();
    }

    private SynchronizeResult _getOrCreateContent(final Map<String, Object> mapping, final Map<String, String> row, ContentType contentType, Optional<String> workflowName, int createAction, String language, List<String> attributeIdNames, Optional<? extends Content> parentContent, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) throws ContentImportException, WorkflowException {
        Map result;
        String xPathQuery;
        AmetysObjectIterable matchingContents;
        AndExpression expression = new AndExpression(new Expression[0]);
        ArrayList<String> values = new ArrayList<String>();
        for (String attributeName : attributeIdNames) {
            ModelItem modelItem = contentType.getModelItem(attributeName);
            String attributePath = (String)mapping.get(attributeName);
            String value = row.get(attributePath);
            values.add(value);
            if (value == null) {
                return new SynchronizeResult(false, Optional.empty(), false);
            }
            if (modelItem.getType() instanceof MultilingualStringRepositoryElementType) {
                expression.add((Object)new MultilingualStringExpression(attributeName, Expression.Operator.EQ, value, language));
                continue;
            }
            expression.add((Object)new StringExpression(attributeName, Expression.Operator.EQ, value));
        }
        expression.addAll(this.additionalExpressionToRetrieveContent(mapping, row, contentType, parentContent, additionalTransientVars, values));
        expression.add((Object)this._contentTypeEP.createHierarchicalCTExpression(new String[]{contentType.getId()}));
        if (!contentType.isMultilingual()) {
            expression.add((Object)new StringExpression("language", Expression.Operator.EQ, language, ExpressionContext.newInstance().withInternal(true)));
        }
        if ((matchingContents = this._resolver.query(xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)expression))).getSize() > 1L) {
            throw new ContentImportException("More than one content found for type " + contentType.getId() + " with " + String.valueOf(attributeIdNames) + " as identifier and " + String.valueOf(values) + " as value");
        }
        if (matchingContents.getSize() == 1L) {
            return new SynchronizeResult(false, Optional.of((ModifiableWorkflowAwareContent)matchingContents.iterator().next()), true);
        }
        if (importMode == SynchronizeModeEnumerator.ImportMode.UPDATE_ONLY) {
            return new SynchronizeResult(false, Optional.empty(), true);
        }
        if (contentType.isAbstract()) {
            throw new ContentImportException("Can not create content for type " + contentType.getId() + " with " + String.valueOf(attributeIdNames) + " as identifier and " + String.valueOf(values) + " as value, the content type is abstract");
        }
        String title = mapping.containsKey("title") ? row.get(mapping.get("title")) : this._i18nUtils.translate((I18nizable)contentType.getDefaultTitle(), language);
        String finalWorkflowName = workflowName.or(() -> ((ContentType)contentType).getDefaultWorkflowName()).orElseThrow(() -> new ContentImportException("No workflow specified for content type " + contentType.getId() + " with " + String.valueOf(attributeIdNames) + " as identifier and " + String.valueOf(values) + " as value"));
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(CreateContentFunction.INITIAL_VALUE_SUPPLIER, new Function<List<String>, Object>(){

            @Override
            public Object apply(List<String> keys) {
                Map nestedValue = mapping;
                for (String key : keys) {
                    if ((nestedValue = nestedValue.get(key)) == null) {
                        return null;
                    }
                    if (!(nestedValue instanceof Map)) continue;
                    nestedValue = nestedValue.get("values");
                }
                return row.get(nestedValue.toString());
            }
        });
        parentContent.ifPresent(content -> inputs.put(CreateContentFunction.PARENT_CONTEXT_VALUE, content.getId()));
        inputs.putAll(additionalTransientVars);
        String prefix = StringUtils.substringAfterLast((String)contentType.getId(), (String)".").toLowerCase();
        String contentName = prefix + "-" + title;
        if (contentType.isMultilingual()) {
            inputs.put(CreateContentFunction.CONTENT_LANGUAGE_KEY, language);
            result = this._contentWorkflowHelper.createContent(finalWorkflowName, createAction, contentName, Map.of(language, title), new String[]{contentType.getId()}, null, inputs);
        } else {
            result = this._contentWorkflowHelper.createContent(finalWorkflowName, createAction, contentName, title, new String[]{contentType.getId()}, null, language, inputs);
        }
        ModifiableWorkflowAwareContent content2 = (ModifiableWorkflowAwareContent)result.get(AbstractContentWorkflowComponent.CONTENT_KEY);
        return new SynchronizeResult(true, Optional.of(content2), true);
    }

    private Map<String, Object> _getValues(Optional<ModifiableWorkflowAwareContent> content, Map<String, String> row, View view, Map<String, Object> mappingValues, int createAction, int editAction, String language, List<ViewItem> errors, SynchronizeModeEnumerator.ImportMode importMode, Map<String, Object> additionalTransientVars) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (ViewItem viewItem : view.getViewItems()) {
            try {
                Object value = this._getValue(content, viewItem, mappingValues, row, createAction, editAction, language, errors, "", importMode, additionalTransientVars);
                if (value == null) continue;
                values.put(viewItem.getName(), value);
            }
            catch (Exception e) {
                errors.add(viewItem);
                this.getLogger().error("Import from CSV file: error while trying to get values for item '{}'", (Object)viewItem.getName(), (Object)e);
            }
        }
        return values;
    }

    private boolean _allAttributesFilled(Map<String, Object> mappingValues, List<String> attributeNames) {
        return mappingValues.entrySet().stream().filter(entry -> attributeNames.contains(entry.getKey())).map(Map.Entry::getValue).allMatch(Objects::nonNull);
    }

    protected record SynchronizeResult(boolean isCreated, Optional<ModifiableWorkflowAwareContent> content, boolean hasKey) {
    }
}

