/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import com.opensymphony.workflow.InvalidActionException;
import com.opensymphony.workflow.WorkflowException;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.HttpUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.contentio.synchronize.AbstractStaticSynchronizableContentsCollection;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.OrExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractSynchronizableContentsCollection
extends AbstractStaticSynchronizableContentsCollection {
    protected static final String SCC_UNIQUE_ID = "scc$uniqueid";
    protected I18nUtils _i18nUtils;
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected UserLanguagesManager _userLanguagesManager;
    protected int _nbError;
    protected boolean _hasGlobalError;
    protected int _nbCreatedContents;
    protected int _nbSynchronizedContents;
    protected int _nbNotChangedContents;
    protected int _nbDeletedContents;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)manager.lookup(UserLanguagesManager.ROLE);
    }

    @Override
    public List<ModifiableContent> populate(Logger logger, ContainerProgressionTracker progressionTracker) {
        ContainerProgressionTracker internalPopulaitePT = progressionTracker.addContainerStep("internalpopulate", new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_IMPORT_SYNCHRONIZE_CONTENTS_STEP_LABEL"), 2.0);
        SimpleProgressionTracker deleteUnexistingContentsPT = progressionTracker.addSimpleStep("deleteunexistingcontents", new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_DELETE_UNEXISTING_CONTENTS_STEP_LABEL"));
        SimpleProgressionTracker notifyPT = progressionTracker.addSimpleStep("notify", new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_NOTIFY_OBSERVERS_AND_SEND_MAILS_STEP_LABEL"));
        this._nbCreatedContents = 0;
        this._nbSynchronizedContents = 0;
        this._nbNotChangedContents = 0;
        this._nbDeletedContents = 0;
        this._nbError = 0;
        this._hasGlobalError = false;
        logger.info("Start synchronization of collection '{}'", (Object)this.getId());
        ArrayList<Long> times = new ArrayList<Long>();
        times.add(System.currentTimeMillis());
        List<ModifiableContent> populatedContents = this._internalPopulate(logger, internalPopulaitePT);
        if (!this._hasGlobalError && this.removalSync()) {
            this.deleteUnexistingContents(logger);
        }
        deleteUnexistingContentsPT.increment();
        times.add(System.currentTimeMillis());
        logger.info("[Synchronization of collection '{}'] Populated in {} ms", (Object)this.getId(), (Object)((Long)times.get(times.size() - 1) - (Long)times.get(times.size() - 2)));
        this._logSynchronizationResult(logger);
        notifyPT.setSize(2L);
        if (this._hasSomethingChanged()) {
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("collection.id", this.getId());
            eventParams.put("collection.contentttype", this.getContentType());
            this._observationManager.notify(new Event("contentio.collection.synchronized", this._currentUserProvider.getUser(), eventParams));
            times.add(System.currentTimeMillis());
            logger.info("[Synchronization of collection '{}'] Listeners notified in {} ms", (Object)this.getId(), (Object)((Long)times.get(times.size() - 1) - (Long)times.get(times.size() - 2)));
        }
        notifyPT.increment();
        if (this._nbError > 0 && this.getReportMails().length() > 0) {
            try {
                logger.warn("{} contents were not created/updated because of an error.", (Object)this._nbError);
                this.sendErrorMail(this._nbError);
                times.add(System.currentTimeMillis());
                logger.info("[Synchronization of collection '{}'] Error mail sent in {} ms", (Object)this.getId(), (Object)((Long)times.get(times.size() - 1) - (Long)times.get(times.size() - 2)));
            }
            catch (MessagingException | IOException e) {
                logger.warn("Unable to send mail", e);
            }
        }
        notifyPT.increment();
        logger.info("[Synchronization of collection '{}'] Total in {} ms", (Object)this.getId(), (Object)((Long)times.get(times.size() - 1) - (Long)times.get(0)));
        return populatedContents;
    }

    protected List<ModifiableContent> _internalPopulate(Logger logger) {
        return this._internalPopulate(logger, ProgressionTrackerFactory.createContainerProgressionTracker((String)"Internal populate", (Logger)logger));
    }

    protected abstract List<ModifiableContent> _internalPopulate(Logger var1, ContainerProgressionTracker var2);

    @Override
    public void empty(Logger logger) {
        Expression collectionExpression = this._sccHelper.getCollectionExpression(this.getId());
        String xPathQuery = ContentQueryHelper.getContentXPathQuery((Expression)collectionExpression);
        List<ModifiableContent> contentsToRemove = this._resolver.query(xPathQuery).stream().toList();
        this._removeSCCOrDeleteContents(contentsToRemove, logger);
    }

    protected void deleteUnexistingContents(Logger logger) {
        String query = this._getContentPathQuery(null, null, null, true);
        AmetysObjectIterable contents = this._resolver.query(query);
        List<ModifiableContent> contentsToRemove = this._getContentsToRemove((AmetysObjectIterable<ModifiableContent>)contents);
        if (!contentsToRemove.isEmpty()) {
            if (logger.isInfoEnabled()) {
                contentsToRemove.stream().forEach(content -> logger.info("The content '{}' ({}) does not exist anymore in remote source: it will be deleted if possible.", (Object)content.getTitle(), (Object)content.getId()));
            }
            this._nbDeletedContents = this._removeSCCOrDeleteContents(contentsToRemove, logger);
        }
    }

    protected abstract List<ModifiableContent> _getContentsToRemove(AmetysObjectIterable<ModifiableContent> var1);

    protected int _removeSCCOrDeleteContents(List<ModifiableContent> contents, Logger logger) {
        logger.info("Remove SCC on contents with multiple SCC... {} contents for all the deletion process.", (Object)contents.size());
        ArrayList<Content> contentsToReallyDelete = new ArrayList<Content>();
        for (ModifiableContent content : contents) {
            if (this._sccHelper.getSynchronizableCollectionIds((Content)content).size() > 1) {
                this._sccHelper.removeSCCProperty((Content)content, this.getId());
                content.saveChanges();
                continue;
            }
            contentsToReallyDelete.add((Content)content);
        }
        logger.info("Remove contents with single SCC... {} contents remaining.", (Object)contentsToReallyDelete.size());
        int nbDeletedContents = this._deleteContents(contentsToReallyDelete, logger);
        logger.info("Contents deleting process ended. {} contents has been deleted.", (Object)nbDeletedContents);
        return nbDeletedContents;
    }

    protected int _deleteContents(List<Content> contentsToRemove, Logger logger) {
        return this._contentDAO.forceDeleteContentsWithLog(contentsToRemove, null, logger);
    }

    protected void _logSynchronizationResult(Logger logger) {
        logger.info("{} contents were created", (Object)this._nbCreatedContents);
        logger.info("{} contents were updated", (Object)this._nbSynchronizedContents);
        logger.info("{} contents did not changed", (Object)this._nbNotChangedContents);
        logger.info("{} contents were deleted", (Object)this._nbDeletedContents);
    }

    protected boolean _hasSomethingChanged() {
        return this._nbCreatedContents > 0 || this._nbSynchronizedContents > 0 || this._nbDeletedContents > 0;
    }

    protected void sendErrorMail(int nbError) throws MessagingException, IOException {
        String language = this._userLanguagesManager.getDefaultLanguage();
        String pluginName = "plugin.contentio";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getId());
        String subject = this._i18nUtils.translate((I18nizable)new I18nizableText(pluginName, "PLUGINS_CONTENTIO_POPULATE_REPORT_MAIL_SUBJECT", params), language);
        params.clear();
        params.add(String.valueOf(nbError));
        params.add(this.getId());
        String baseUrl = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("cms.url")));
        params.add(baseUrl + "/_admin/index.html?uitool=uitool-admin-logs");
        String body = this._i18nUtils.translate((I18nizable)new I18nizableText(pluginName, "PLUGINS_CONTENTIO_POPULATE_REPORT_MAIL_BODY", params), language);
        SendMailHelper.newMail().withSubject(subject).withTextBody(body).withRecipients(Arrays.asList(this.getReportMails().split("\\n"))).sendMail();
    }

    protected void validateContent(WorkflowAwareContent content, int validationActionId, Logger logger) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        try {
            this._contentWorkflowHelper.doAction(content, validationActionId, inputs);
            logger.info("The content {} has been validated after import", (Object)content);
        }
        catch (InvalidActionException | WorkflowException e) {
            String failuresAsString = this._getActionFailuresAsString(inputs);
            logger.error("The content {} cannot be validated after import{}", new Object[]{content, failuresAsString, e});
        }
    }

    private String _getActionFailuresAsString(Map<String, Object> actionInputs) {
        List failures;
        Object failuresAsString = "";
        if (actionInputs.containsKey(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY) && !(failures = (List)actionInputs.get(AbstractWorkflowComponent.FAIL_CONDITIONS_KEY)).isEmpty()) {
            failuresAsString = ", due to the following error(s):\n" + String.join((CharSequence)"\n", failures.stream().map(AbstractWorkflowComponent.ConditionFailure::text).toList());
        }
        return failuresAsString;
    }

    protected ModifiableContent createContentAction(String contentType, String workflowName, int initialActionId, String lang, String contentTitle, Logger logger) {
        try {
            logger.info("Creating content '{}' with the content type '{}' for language {}", new Object[]{contentTitle, this.getContentType(), lang});
            String desiredContentName = this._contentPrefix + "-" + contentTitle + "-" + lang;
            Map<String, Object> inputs = this._getAdditionalInputsForContentCreation();
            Map result = this._contentWorkflowHelper.createContent(workflowName, initialActionId, desiredContentName, contentTitle, new String[]{contentType}, null, lang, inputs);
            return (ModifiableContent)result.get(Content.class.getName());
        }
        catch (WorkflowException e) {
            ++this._nbError;
            logger.error("Failed to initialize workflow for content {} and language {}", new Object[]{contentTitle, lang, e});
            return null;
        }
    }

    protected Map<String, Object> _getAdditionalInputsForContentCreation() {
        return new HashMap<String, Object>();
    }

    protected List<Expression> _getExpressionsList(String lang, String idValue, String contentType, boolean forceStrictCheck) {
        ArrayList<Expression> expList = new ArrayList<Expression>();
        if (forceStrictCheck) {
            expList.add(this._sccHelper.getCollectionExpression(this.getId()));
        } else if (this.checkCollection()) {
            expList.add((Expression)this.getCompatibleSCC(true).stream().map(this._sccHelper::getCollectionExpression).collect(Collectors.toCollection(() -> new OrExpression(new Expression[0]))));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            expList.add((Expression)new ContentTypeExpression(Expression.Operator.EQ, new String[]{contentType}));
        }
        if (StringUtils.isNotBlank((CharSequence)idValue)) {
            expList.add((Expression)new StringExpression(this.getIdField(), Expression.Operator.EQ, idValue));
        }
        if (StringUtils.isNotBlank((CharSequence)lang)) {
            expList.add((Expression)new LanguageExpression(Expression.Operator.EQ, lang));
        }
        return expList;
    }

    protected String _getContentPathQuery(String lang, String idValue, String contentType, boolean forceStrictCheck) {
        List<Expression> expList = this._getExpressionsList(lang, idValue, contentType, forceStrictCheck);
        AndExpression andExp = new AndExpression(expList);
        return ContentQueryHelper.getContentXPathQuery((Expression)andExp);
    }

    protected Map<String, Object> _removeEmptyParameters(Map<String, Object> searchParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String parameterName : searchParameters.keySet()) {
            Object parameterValue = searchParameters.get(parameterName);
            if (!this._isParamNotEmpty(parameterValue)) continue;
            result.put(parameterName, parameterValue);
        }
        return result;
    }

    protected boolean _isParamNotEmpty(Object parameterValue) {
        return parameterValue != null && (!(parameterValue instanceof String) || !StringUtils.isBlank((CharSequence)((String)parameterValue)));
    }

    @Override
    public Map<String, Integer> getSynchronizationResult() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("nbCreatedContents", this._nbCreatedContents);
        result.put("nbSynchronizedContents", this._nbSynchronizedContents);
        result.put("nbNotChangedContents", this._nbNotChangedContents);
        result.put("nbDeletedContents", this._nbDeletedContents);
        return result;
    }
}

