/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.clientsideelement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ametys.cms.clientsideelement.SmartContentClientSideElement;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableDefaultContent;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.core.ui.log.LogManager;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class SCCSmartContentClientSideElement
extends SmartContentClientSideElement {
    protected LogManager _logManager;
    protected SynchronizableContentsCollectionHelper _sccHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._logManager = (LogManager)smanager.lookup(LogManager.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)((Object)smanager.lookup(SynchronizableContentsCollectionHelper.ROLE));
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        ArrayList<ClientSideElement.Script> clonedScripts = new ArrayList<ClientSideElement.Script>();
        List scripts = super.getScripts(ignoreRights, contextParameters);
        for (ClientSideElement.Script script : scripts) {
            String sccModelId;
            SynchronizableContentsCollection collection;
            if (!script.getParameters().containsKey("sccModelId") || (collection = this._sccHelper.getSCCFromModelId(sccModelId = (String)script.getParameters().get("sccModelId"))) == null) continue;
            clonedScripts.add(this._getScriptFromCollection(script, collection));
        }
        return clonedScripts;
    }

    protected ClientSideElement.Script _getScriptFromCollection(ClientSideElement.Script script, SynchronizableContentsCollection collection) {
        ClientSideElement.Script clonedScript = new ClientSideElement.Script(script);
        clonedScript.getParameters().put("collectionId", collection.getId());
        return clonedScript;
    }

    @Callable(rights={""})
    public boolean synchronizeContent(String collectionId, String contentId, String syncCode) {
        ModifiableDefaultContent content = (ModifiableDefaultContent)this._resolver.resolveById(contentId);
        if (!this._hasRight((Content)content)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to synchronize content '" + contentId + "' without sufficient right");
        }
        return this._sccHelper.synchronizeContent(collectionId, contentId, syncCode);
    }

    @Callable(rights={""})
    public String getSyncCode(String contentId, String collectionId) {
        ModifiableDefaultContent content = (ModifiableDefaultContent)this._resolver.resolveById(contentId);
        if (!this._hasRight((Content)content)) {
            throw new AccessDeniedException("User '" + String.valueOf(this._currentUserProvider.getUser()) + "' tried to get synchronization code of content '" + contentId + "' without sufficient right");
        }
        return this._sccHelper.getSyncCode(contentId, collectionId);
    }

    @Callable(rights={""})
    public List<Map<String, Object>> getEvents(Long timestamp, List<String> categories) {
        if (!this.hasRight(this.getRights(Map.of()))) {
            throw new AccessDeniedException("The user '" + String.valueOf(this._currentUserProvider.getUser()) + "' try to get logs without sufficient rights");
        }
        return this._logManager.getEvents(timestamp, List.of("org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper"));
    }
}

