/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionModel;
import org.ametys.plugins.contentio.synchronize.SynchronizeContentsCollectionModelExtensionPoint;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class CollectionDataSourceConsumer
implements DataSourceConsumer,
Component,
Serviceable {
    public static final String ROLE = CollectionDataSourceConsumer.class.getName();
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    protected SynchronizeContentsCollectionModelExtensionPoint _synchronizeContentsCollectionModelEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)((Object)manager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._synchronizeContentsCollectionModelEP = (SynchronizeContentsCollectionModelExtensionPoint)((Object)manager.lookup(SynchronizeContentsCollectionModelExtensionPoint.ROLE));
    }

    public DataSourceConsumer.TypeOfUse isInUse(String id) {
        for (String modelId : this._synchronizeContentsCollectionModelEP.getExtensionsIds()) {
            SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._synchronizeContentsCollectionModelEP.getExtension(modelId);
            List<String> datasourceParameters = model.getModelItems().stream().filter(parameter -> "datasource".equals(parameter.getType().getId())).map(ModelItem::getPath).toList();
            for (SynchronizableContentsCollection collection : this._synchronizableContentsCollectionDAO.getSynchronizableContentsCollections()) {
                if (!modelId.equals(collection.getSynchronizeCollectionModelId())) continue;
                for (String datasourceParameter : datasourceParameters) {
                    if (!id.equals(collection.getParameterValues().get(datasourceParameter))) continue;
                    return DataSourceConsumer.TypeOfUse.NON_BLOCKING;
                }
            }
        }
        return DataSourceConsumer.TypeOfUse.NOT_USED;
    }

    public Map<String, DataSourceConsumer.TypeOfUse> getUsedDataSourceIds() {
        HashMap<String, DataSourceConsumer.TypeOfUse> result = new HashMap<String, DataSourceConsumer.TypeOfUse>();
        for (String modelId : this._synchronizeContentsCollectionModelEP.getExtensionsIds()) {
            SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._synchronizeContentsCollectionModelEP.getExtension(modelId);
            List<String> datasourceParameters = model.getModelItems().stream().filter(parameter -> "datasource".equals(parameter.getType().getId())).map(ModelItem::getPath).toList();
            for (SynchronizableContentsCollection collection : this._synchronizableContentsCollectionDAO.getSynchronizableContentsCollections()) {
                for (String datasourceParameter : datasourceParameters) {
                    result.put((String)collection.getParameterValues().get(datasourceParameter), DataSourceConsumer.TypeOfUse.NON_BLOCKING);
                }
            }
        }
        return result;
    }
}

