/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.rights;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SynchronizedRootContentHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = SynchronizedRootContentHelper.class.getName();
    public static final String CONTENTIO_ROOT_NODE = "contentio";
    public static final String IMPORTED_CONTENTS_ROOT_NODE = "ametys:contents";
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public AmetysObjectCollection getRootContent(boolean create) {
        ModifiableTraversableAmetysObject contentIoNode;
        ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins/");
        boolean needSave = false;
        if (!pluginsNode.hasChild(CONTENTIO_ROOT_NODE)) {
            if (create) {
                pluginsNode.createChild(CONTENTIO_ROOT_NODE, "ametys:unstructured");
                needSave = true;
            } else {
                throw new UnknownAmetysObjectException("Node '/ametys:plugins/contentio' is missing");
            }
        }
        if (!(contentIoNode = (ModifiableTraversableAmetysObject)pluginsNode.getChild(CONTENTIO_ROOT_NODE)).hasChild(IMPORTED_CONTENTS_ROOT_NODE)) {
            if (create) {
                contentIoNode.createChild(IMPORTED_CONTENTS_ROOT_NODE, "ametys:collection");
                needSave = true;
            } else {
                throw new UnknownAmetysObjectException("Node '/ametys:plugins/contentio/ametys:contents' is missing");
            }
        }
        if (needSave) {
            pluginsNode.saveChanges();
        }
        return (AmetysObjectCollection)contentIoNode.getChild(IMPORTED_CONTENTS_ROOT_NODE);
    }

    public boolean isChildOfRootContent(Content content) {
        try {
            AmetysObjectCollection rootContent = this.getRootContent(false);
            for (AmetysObject parent = content.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.equals((Object)rootContent)) continue;
                return true;
            }
            return false;
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }
}

