/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.search.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ametys.cms.search.query.NotQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.QuerySyntaxException;

public class CollectionsQuery
implements Query {
    private Query.Operator _operator;
    private List<String> _collectionIds;

    public CollectionsQuery(String ... ids) {
        this(Query.Operator.EQ, ids);
    }

    public CollectionsQuery(Collection<String> ids) {
        this(Query.Operator.EQ, ids);
    }

    public CollectionsQuery(Query.Operator operator, String ... ids) {
        this(operator, Arrays.asList(ids));
    }

    public CollectionsQuery(Query.Operator operator, Collection<String> ids) {
        if (Query.Operator.EQ != operator && Query.Operator.NE != operator) {
            throw new IllegalArgumentException("Test operator '" + String.valueOf(operator) + "' is unknown for test's expression.");
        }
        this._operator = operator;
        this._collectionIds = new ArrayList<String>(ids);
    }

    public String build() throws QuerySyntaxException {
        StringBuilder query = new StringBuilder();
        if (this._operator == Query.Operator.NE) {
            NotQuery.appendNegation((StringBuilder)query).append('(');
        }
        boolean first = true;
        for (String collectionId : this._collectionIds) {
            if (!first) {
                query.append(" OR ");
            }
            query.append('(').append("scc").append(':').append(collectionId).append(')');
            first = false;
        }
        if (this._operator == Query.Operator.NE) {
            query.append(')');
        }
        return query.toString();
    }
}

