/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentstree;

/**
 * The child is the value of an attribute
 */
public class AttributeTreeConfigurationElementsChild implements TreeConfigurationElementsChild
{
    /** The attribute path (without leading /) */
    protected String _path;

    /**
     * Create the child
     * @param path The attribute path (without leading /)
     */
    public AttributeTreeConfigurationElementsChild(String path)
    {
        _path = path;
    }
    
    /**
     * Get the attribute ref path
     * @return The attribute ref path without leading /.
     */
    public String getPath()
    {
        return _path;
    }
}
