/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentstree.ui;

import java.util.HashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.model.ModelItem;

/**
 * Static client side element for adding content under the currently selected content
 */
public class AddContentToCurrentSelectionClientSideElement extends StaticClientSideElement
{
    private AmetysObjectResolver _ametysResolver;
    private ContentTypeExtensionPoint _contentTypeEP;
 
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        
        _ametysResolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
        _contentTypeEP = (ContentTypeExtensionPoint) smanager.lookup(ContentTypeExtensionPoint.ROLE);
    }
    
    /**
     * Get the type of the required model item between content or sub-content
     * @param contentId The content to check
     * @param modelItemPath The path to check
     * @return The type in key "type".
     */
    @Callable
    public Map<String, Object> getModelItemType(String contentId, String modelItemPath)
    {
        Map<String, Object> result = new HashMap<>();
        
        Content content = _ametysResolver.resolveById(contentId);
        for (String contentTypeId : content.getTypes())
        {
            ContentType contentType = _contentTypeEP.getExtension(contentTypeId);
            if (contentType.hasModelItem(modelItemPath))
            {
                ModelItem modelItem = contentType.getModelItem(modelItemPath);
                if (modelItem instanceof ContentAttributeDefinition)
                {
                    ContentAttributeDefinition contentAttributeDefinition = (ContentAttributeDefinition) modelItem;
                    result.put("model-item-type", contentAttributeDefinition.getType().getId());
                    result.put("contenttype", contentAttributeDefinition.getContentTypeId());
                    result.put("language", content.getLanguage());
                    break;
                }
                else
                {
                    throw new IllegalArgumentException("The content '" + contentId + "' has a metadata '" + modelItemPath + "' in content type '" + contentTypeId + "' but its type is neither a CONTENT neither a SUB_CONTENT.");
                }
            }
        }
        
        return result;
    }
}
