/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentstree;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.plugins.contentstree.AttributeTreeConfigurationElementsChild;
import org.ametys.plugins.contentstree.TreeConfiguration;
import org.ametys.plugins.contentstree.TreeConfigurationContentType;
import org.ametys.plugins.contentstree.TreeConfigurationElements;
import org.ametys.plugins.contentstree.TreeConfigurationElementsChild;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class StaticTreeConfiguration
implements TreeConfiguration,
Configurable,
Serviceable,
PluginAware {
    protected String _uiToolRole;
    protected Set<TreeConfigurationElements> _elements;
    protected ContentTypeExtensionPoint _contentTypesEP;
    protected SourceResolver _sourceResolver;
    protected String _pluginName;
    protected String _id;
    private Configuration _configuration;

    @Override
    public String getId() {
        return this._id;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._contentTypesEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration initialConfiguration) throws ConfigurationException {
        this._id = initialConfiguration.getAttribute("id");
        this._configuration = this._getDeportedConfiguration(initialConfiguration);
    }

    private void _lazyConfigure() {
        if (this._configuration != null) {
            try {
                this._uiToolRole = this._configuration.getAttribute("id");
                this._elements = new HashSet<TreeConfigurationElements>();
                for (Configuration contentTypeConfiguration : this._configuration.getChild("elements").getChildren("content-type")) {
                    Collection<TreeConfigurationContentType> contentTypesInfo = this.getContentTypesInfos(contentTypeConfiguration.getChild("ids"));
                    Collection<TreeConfigurationElementsChild> childNodes = this.getChildNodes(contentTypeConfiguration.getChild("children"));
                    TreeConfigurationElements element = new TreeConfigurationElements(contentTypesInfo, childNodes);
                    this._elements.add(element);
                }
                this._configuration = null;
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("An error occured while configuring tree '" + this._id + "'", e);
            }
        }
    }

    /*
     * Loose catch block
     */
    private Configuration _getDeportedConfiguration(Configuration initialConfiguration) throws ConfigurationException {
        Configuration configuration;
        InputStream is;
        Source treeConfigSource;
        String treeConfigURL;
        block10: {
            treeConfigURL = initialConfiguration.getChild("tree-config").getValue();
            treeConfigSource = null;
            treeConfigSource = this._sourceResolver.resolveURI(treeConfigURL, "plugin:" + this._pluginName + "://", null);
            is = treeConfigSource.getInputStream();
            configuration = new DefaultConfigurationBuilder().build(is);
            if (is == null) break block10;
            is.close();
        }
        this._sourceResolver.release(treeConfigSource);
        return configuration;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new ConfigurationException("Cannot open the file '" + treeConfigURL + "'", initialConfiguration, (Throwable)e);
                    }
                }
                catch (Throwable throwable3) {
                    this._sourceResolver.release(treeConfigSource);
                    throw throwable3;
                }
            }
        }
    }

    protected Collection<TreeConfigurationElementsChild> getChildNodes(Configuration configuration) throws ConfigurationException {
        ArrayList<TreeConfigurationElementsChild> childnodes = new ArrayList<TreeConfigurationElementsChild>();
        for (Configuration childConfiguration : configuration.getChildren()) {
            if (!StringUtils.equals((CharSequence)childConfiguration.getName(), (CharSequence)"metadata")) {
                throw new ConfigurationException("Unknown child of type '" + childConfiguration.getName() + "'", childConfiguration);
            }
            String id = childConfiguration.getAttribute("id");
            AttributeTreeConfigurationElementsChild child = new AttributeTreeConfigurationElementsChild(id);
            childnodes.add(child);
        }
        return childnodes;
    }

    protected Collection<TreeConfigurationContentType> getContentTypesInfos(Configuration configuration) throws ConfigurationException {
        ArrayList<TreeConfigurationContentType> contentTypesInfo = new ArrayList<TreeConfigurationContentType>();
        boolean elementsCanBeRoot = configuration.getAttributeAsBoolean("can-be-root", false);
        boolean elementsAutoExpandTarget = configuration.getAttributeAsBoolean("auto-expand-target", false);
        boolean elementsInherit = configuration.getAttributeAsBoolean("inherit", false);
        String elementsBusMessageType = configuration.getAttribute("bus-message-type", "content");
        for (Configuration idConfiguration : configuration.getChildren("id")) {
            TreeConfigurationContentType contentTypeInfo = this.getContentTypeInfo(idConfiguration, elementsCanBeRoot, elementsAutoExpandTarget, elementsInherit, elementsBusMessageType);
            contentTypesInfo.add(contentTypeInfo);
        }
        return contentTypesInfo;
    }

    protected TreeConfigurationContentType getContentTypeInfo(Configuration configuration, boolean defaultCanBeRoot, boolean defaultAutoExpandToIt, boolean defaultInherit, String defaultBusMessageType) throws ConfigurationException {
        boolean canBeRoot = configuration.getAttributeAsBoolean("can-be-root", defaultCanBeRoot);
        boolean autoExpandToIt = configuration.getAttributeAsBoolean("auto-expand-to-it", defaultAutoExpandToIt);
        String mainContentTypeId = configuration.getValue();
        ArrayList<String> typesIds = new ArrayList<String>();
        typesIds.add(mainContentTypeId);
        boolean inherit = configuration.getAttributeAsBoolean("inherit", defaultInherit);
        if (inherit) {
            typesIds.addAll(this._contentTypesEP.getSubTypes(mainContentTypeId));
        }
        String busMessageType = configuration.getAttribute("bus-message-type", defaultBusMessageType);
        return new TreeConfigurationContentType(canBeRoot, autoExpandToIt, typesIds, busMessageType);
    }

    @Override
    public String getUIToolRole() {
        this._lazyConfigure();
        return this._uiToolRole;
    }

    @Override
    public Set<TreeConfigurationElements> getElements() {
        this._lazyConfigure();
        return this._elements;
    }
}

