/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentstree.ui;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.contentstree.TreeConfiguration;
import org.ametys.plugins.contentstree.TreeConfigurationContentType;
import org.ametys.plugins.contentstree.TreeConfigurationElements;
import org.ametys.plugins.contentstree.TreeExtensionPoint;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class OpenTreeControllerClientSideElement
extends StaticClientSideElement {
    protected TreeExtensionPoint _treeExtensionPoint;
    protected String _treeConfigId;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._treeExtensionPoint = (TreeExtensionPoint)((Object)smanager.lookup(TreeExtensionPoint.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._treeConfigId = configuration.getChild("tree-config").getValue();
    }

    protected void _lazyConfigure() {
        if (this._treeConfigId != null) {
            TreeConfiguration treeConfiguration = (TreeConfiguration)this._treeExtensionPoint.getExtension(this._treeConfigId);
            this._script.getParameters().put("opentool-id", treeConfiguration.getUIToolRole());
            HashMap<String, String> openToolParams = new HashMap<String, String>();
            openToolParams.put("treeId", this._treeConfigId);
            this._script.getParameters().put("opentool-params", openToolParams);
            HashSet<CallSite> busMessageTypesRegExp = new HashSet<CallSite>();
            HashSet<CallSite> contentTypeIdsRegExp = new HashSet<CallSite>();
            for (TreeConfigurationElements element : treeConfiguration.getElements()) {
                for (TreeConfigurationContentType contentTypeInfo : element.getContentTypesConfiguration()) {
                    if (!contentTypeInfo.canBeRoot()) continue;
                    busMessageTypesRegExp.add((CallSite)((Object)("^" + contentTypeInfo.getMessageBusType() + "$")));
                    for (String id : contentTypeInfo.getContentTypesIds()) {
                        contentTypeIdsRegExp.add((CallSite)((Object)("^" + id + "$")));
                    }
                }
            }
            this._script.getParameters().put("selection-target-id", StringUtils.join(busMessageTypesRegExp, (String)"|"));
            HashMap<String, String> selectionTargetParameter = new HashMap<String, String>();
            selectionTargetParameter.put("name", "^types$");
            selectionTargetParameter.put("value", StringUtils.join(contentTypeIdsRegExp, (String)"|"));
            this._script.getParameters().put("selection-target-parameter", selectionTargetParameter);
            this._treeConfigId = null;
        }
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        this._lazyConfigure();
        return super.getScripts(ignoreRights, contextParameters);
    }
}

