/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentstree.ui;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.ClientSideElement;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.contentstree.AttributeTreeConfigurationElementsChild;
import org.ametys.plugins.contentstree.ContentsTreeHelper;
import org.ametys.plugins.contentstree.TreeConfiguration;
import org.ametys.plugins.contentstree.TreeConfigurationContentType;
import org.ametys.plugins.contentstree.TreeConfigurationElements;
import org.ametys.plugins.contentstree.TreeConfigurationElementsChild;
import org.ametys.plugins.contentstree.TreeExtensionPoint;
import org.ametys.runtime.model.ModelItem;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class TreeToolClientSideElement
extends StaticClientSideElement {
    protected ContentsTreeHelper _treeHelper;
    protected TreeExtensionPoint _treeExtensionPoint;
    protected String _treeConfigId;
    protected ContentTypesHelper _contentTypesHelper;
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._treeHelper = (ContentsTreeHelper)((Object)smanager.lookup(ContentsTreeHelper.ROLE));
        this._treeExtensionPoint = (TreeExtensionPoint)((Object)smanager.lookup(TreeExtensionPoint.ROLE));
        this._contentTypesHelper = (ContentTypesHelper)smanager.lookup(ContentTypesHelper.ROLE);
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._treeConfigId = configuration.getChild("tree-config").getValue();
    }

    protected void _lazyConfigure() {
        if (this._treeConfigId != null) {
            TreeConfiguration treeConfiguration = (TreeConfiguration)this._treeExtensionPoint.getExtension(this._treeConfigId);
            this._script.getParameters().put("treeId", this._treeConfigId);
            HashSet<CallSite> busMessageTypesRegExp = new HashSet<CallSite>();
            HashSet<CallSite> contentTypeIdsRegExp = new HashSet<CallSite>();
            HashMap<String, String> contenttypeAndMessagebustype = new HashMap<String, String>();
            HashMap contentTypeAndAttributePathsByContentType = new HashMap();
            for (TreeConfigurationElements element : treeConfiguration.getElements()) {
                for (TreeConfigurationContentType contentTypeInfo : element.getContentTypesConfiguration()) {
                    if (contentTypeInfo.canBeRoot()) {
                        busMessageTypesRegExp.add((CallSite)((Object)("^" + contentTypeInfo.getMessageBusType() + "$")));
                    }
                    for (String id : contentTypeInfo.getContentTypesIds()) {
                        HashMap contentTypeAndAttributePaths = new HashMap();
                        contentTypeAndAttributePathsByContentType.put(id, contentTypeAndAttributePaths);
                        if (contentTypeInfo.canBeRoot()) {
                            contentTypeIdsRegExp.add((CallSite)((Object)("^" + id + "$")));
                        }
                        contenttypeAndMessagebustype.put(id, contentTypeInfo.getMessageBusType());
                        for (TreeConfigurationElementsChild treeConfigurationElementsChild : element.getChildren()) {
                            if (!(treeConfigurationElementsChild instanceof AttributeTreeConfigurationElementsChild)) continue;
                            AttributeTreeConfigurationElementsChild attributeTreeConfigurationElementsChild = (AttributeTreeConfigurationElementsChild)treeConfigurationElementsChild;
                            String attributePath = attributeTreeConfigurationElementsChild.getPath();
                            ArrayList<String> contentTypes = new ArrayList<String>();
                            contentTypeAndAttributePaths.put(attributePath, contentTypes);
                            ContentType contentType = (ContentType)this._contentTypeExtensionPoint.getExtension(id);
                            ModelItem metadataDefinition = contentType.getModelItem(attributePath);
                            if (!(metadataDefinition instanceof ContentAttributeDefinition)) continue;
                            String targetContentTypeId = ((ContentAttributeDefinition)metadataDefinition).getContentTypeId();
                            contentTypes.add(targetContentTypeId);
                            contentTypes.addAll(this._contentTypeExtensionPoint.getSubTypes(targetContentTypeId));
                        }
                    }
                }
            }
            this._script.getParameters().put("messagebustype-by-contenttype", contenttypeAndMessagebustype);
            this._script.getParameters().put("metadatapaths-by-contenttype", contentTypeAndAttributePathsByContentType);
            this._script.getParameters().put("selection-target-id", StringUtils.join(busMessageTypesRegExp, (String)"|"));
            HashMap<String, String> selectionTargetParameter = new HashMap<String, String>();
            selectionTargetParameter.put("name", "^types$");
            selectionTargetParameter.put("value", StringUtils.join(contentTypeIdsRegExp, (String)"|"));
            this._script.getParameters().put("selection-target-parameter", selectionTargetParameter);
        }
    }

    public List<ClientSideElement.Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters) {
        this._lazyConfigure();
        return super.getScripts(ignoreRights, contextParameters);
    }

    @Callable
    public Map<String, Object> getRootNodeInformations(String contentId, String treeId) throws Exception {
        return this._treeHelper.getRootNodeInformations(contentId, treeId);
    }
}

