/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentstree;

import java.util.Set;

/**
 * This interface describe the configuration for a contents tree.
 */
public interface TreeConfiguration
{
    /**
     * Get the extension unique id
     * @return The extension id
     */
    public String getId();
    
    /**
     * Get the tool role for the UI tool factory
     * @return The js role
     */
    public String getUIToolRole();    
    
    /**
     * Get the elements to build the tree
     * @return The elements. Can not be null.
     */
    public Set<TreeConfigurationElements> getElements();
}
