/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import com.opensymphony.workflow.WorkflowException;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.observation.ObservationManager;
import org.ametys.plugins.datafiller.ContentCreationHelper;
import org.ametys.plugins.datafiller.SitemapPopulator;
import org.ametys.plugins.repository.metadata.MultilingualString;
import org.ametys.plugins.ugc.page.UGCPageHandler;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewHelper;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.MetadataAwareSitemapElement;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageDAO;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.LocaleUtils;

public class ClassifiedAdsContentCreationManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ClassifiedAdsContentCreationManager.class.getName();
    private static final String __CLASSIFICATION_ATTRIBUTE = "category";
    private static final String __CATEGORY_CONTENT = "org.ametys.plugins.classified.ads.Content.categories";
    protected UGCPageHandler _ugcPageHandler;
    protected ObservationManager _observationManager;
    private ContentTypeExtensionPoint _cTypeEP;
    private SitemapPopulator _sitemapPopulator;
    private PageDAO _pageDAO;
    private ContentCreationHelper _contentCreationHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._contentCreationHelper = (ContentCreationHelper)((Object)manager.lookup(ContentCreationHelper.ROLE));
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._pageDAO = (PageDAO)manager.lookup(PageDAO.ROLE);
        this._sitemapPopulator = (SitemapPopulator)((Object)manager.lookup(SitemapPopulator.ROLE));
        this._ugcPageHandler = (UGCPageHandler)manager.lookup(UGCPageHandler.ROLE);
    }

    public void createClassifiedAdsPages(Sitemap sitemap) throws Exception {
        ContentType categContentType = (ContentType)this._cTypeEP.getExtension(__CATEGORY_CONTENT);
        Map<String, Object> categValues = this._getValuesForContentType(categContentType);
        MultilingualString titles = new MultilingualString();
        titles.add(LocaleUtils.toLocale((String)"fr"), "Ameublement");
        categValues.put("title", titles);
        Content ameublement = this._createContent(sitemap, "ameublement", categContentType, categValues);
        titles.add(LocaleUtils.toLocale((String)"fr"), "Immobilier");
        Content immobilier = this._createContent(sitemap, "immobilier", categContentType, categValues);
        titles.add(LocaleUtils.toLocale((String)"fr"), "Mode");
        Content mode = this._createContent(sitemap, "mode", categContentType, categValues);
        ModifiablePage rootPage = this._sitemapPopulator.getOrCreatePage((MetadataAwareSitemapElement)sitemap, "Petites annonces");
        try {
            this._pageDAO.setTemplate(List.of(rootPage.getId()), "page");
        }
        catch (IllegalStateException e) {
            this.getLogger().warn("Failed to set template for page {}", (Object)rootPage.getTitle(), (Object)e);
        }
        this._ugcPageHandler.setUGCRoot((Page)rootPage, "org.ametys.plugins.classified.ads.Content.ads", __CLASSIFICATION_ATTRIBUTE, true);
        ContentType contentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.classified.ads.Content.ads");
        Map<String, Object> values = this._getValuesForContentType(contentType);
        values.put(__CLASSIFICATION_ATTRIBUTE, ameublement);
        values.put("title", "Table basse design en bois massif et pieds en fonte style industriel");
        this._createContent(sitemap, "table-basse-petite-annonce", contentType, values);
        values.put(__CLASSIFICATION_ATTRIBUTE, immobilier);
        values.put("title", "Location Chalet tout \u00e9quip\u00e9 avec parking jusqu'\u00e0 8 personnes");
        this._createContent(sitemap, "location-chalet-petite-annonce", contentType, values);
        values.put(__CLASSIFICATION_ATTRIBUTE, mode);
        values.put("title", "Baskets \u00e9dition limit\u00e9e taille 39");
        this._createContent(sitemap, "baskets-petite-annonce", contentType, values);
        values.put("title", "T-shirt bleu chin\u00e9 neuf");
        this._createContent(sitemap, "t-shirt-petite-annonce", contentType, values);
    }

    private Content _createContent(Sitemap sitemap, String contentName, ContentType contentType, Map<String, Object> values) throws WorkflowException {
        WorkflowAwareContent content = this._contentCreationHelper.getContent(contentName, sitemap);
        if (content == null) {
            content = this._contentCreationHelper.initializeContent(contentType, sitemap, contentName);
            content = this._contentCreationHelper.editContent(content, contentType, values);
        }
        return content;
    }

    private Map<String, Object> _getValuesForContentType(ContentType contentType) {
        View view = ViewHelper.getTruncatedView((View)View.of((Model)contentType));
        Map<String, Object> values = this._contentCreationHelper.getGenericValuesForView((ViewItemContainer)view);
        return values;
    }
}

