/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.MalformedURLException;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.Geocode;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.LanguageExpression;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.model.ViewHelper;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.model.ViewItemContainer;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;

public class ContentCreationHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ContentCreationHelper.class.getName();
    private static final String _FILLING_DATA_FOLDER_URI = "plugin:data-filler://filling-data/resources/";
    private static final int _INITIAL_ACTION_ID = 1;
    private static final int _EDIT_ACTION_ID = 2;
    private static final int _VALIDATE_ACTION_ID = 4;
    private static final String _CONTENT_WORKFLOW_NAME = "content";
    private I18nUtils _i18nUtils;
    private AmetysObjectResolver _resolver;
    private SourceResolver _sourceResolver;
    private CurrentUserProvider _currentUserProvider;
    private ContentWorkflowHelper _workflowHelper;
    private WorkflowProvider _workflowProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
    }

    public Map<String, Object> getGenericValuesForView(ViewItemContainer viewItemContainer) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ViewHelper.visitView((ViewItemAccessor)viewItemContainer, (element, definition) -> {
            String name = definition.getName();
            Object value = definition.getDefaultValue();
            if (value != null) {
                result.put(name, value);
            } else if (!name.contains("dc") && !name.contains("title")) {
                try {
                    value = this._getGenericValue((ElementDefinition)definition);
                    if (value != null) {
                        if (definition.isMultiple()) {
                            result.put(name, Set.of(value));
                        } else {
                            result.put(name, value);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, (group, definition) -> {
            String name = definition.getName();
            Map<String, Object> value = this.getGenericValuesForView((ViewItemContainer)group);
            result.put(name, value);
        }, (group, definition) -> {
            String name = definition.getName();
            Map<String, Object> value = this.getGenericValuesForView((ViewItemContainer)group);
            int size = definition.getInitialSize() >= 1 ? definition.getInitialSize() : (definition.getMinSize() >= 1 ? definition.getMinSize() : (definition.getMaxSize() >= 1 ? definition.getMaxSize() : 2));
            result.put(name, Collections.nCopies(size, value));
        }, group -> result.putAll(this.getGenericValuesForView((ViewItemContainer)group)));
        return result;
    }

    private <T> Object _getGenericValue(ElementDefinition<T> definition) throws IOException {
        switch (definition.getType().getId()) {
            case "string": {
                return this._getGenericString(definition);
            }
            case "content": {
                return null;
            }
            case "long": {
                return this._getGenericLong(definition);
            }
            case "boolean": {
                return true;
            }
            case "date": {
                return LocalDate.now();
            }
            case "datetime": {
                return ZonedDateTime.now();
            }
            case "double": {
                return 1.3;
            }
            case "geocode": {
                return new Geocode(Double.valueOf(50.6637), Double.valueOf(-4.7593));
            }
            case "binary": 
            case "file": {
                return this._getGenericFile(definition);
            }
            case "rich-text": {
                return this._getGenericRichText();
            }
            case "user": {
                return this._getGenericUser();
            }
        }
        this.getLogger().warn("Unsupported type '{}'. The attribute will be ignored.", (Object)definition.getType());
        return null;
    }

    private String _getGenericString(ElementDefinition definition) {
        switch (definition.getName()) {
            case "tags": {
                return null;
            }
            case "email": 
            case "mail": {
                return "contact@ametys.org";
            }
            case "link": 
            case "url": 
            case "website": {
                return "https://ametys.org";
            }
        }
        return "Lorem ipsum et tutti quanti";
    }

    private Long _getGenericLong(ElementDefinition definition) {
        switch (definition.getName()) {
            case "height": 
            case "width": {
                return null;
            }
        }
        return 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Object _getGenericFile(ElementDefinition<T> definition) throws MalformedURLException, IOException, SourceNotFoundException {
        filter = Optional.of(definition).map((Function<ElementDefinition, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getWidgetParameters(), (Lorg/ametys/runtime/model/ElementDefinition;)Ljava/util/Map;)()).map((Function<Map, I18nizableText>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$_getGenericFile$4(java.util.Map ), (Ljava/util/Map;)Lorg/ametys/runtime/i18n/I18nizableText;)()).map((Function<I18nizableText, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLabel(), (Lorg/ametys/runtime/i18n/I18nizableText;)Ljava/lang/String;)()).orElse("");
        ressourceFile = null;
        try {
            var6_4 = filter;
            var7_5 = -1;
            switch (var6_4.hashCode()) {
                case 93166550: {
                    if (!var6_4.equals("audio")) break;
                    var7_5 = 0;
                    break;
                }
                case 100313435: {
                    if (!var6_4.equals("image")) break;
                    var7_5 = 1;
                    break;
                }
                case 112202875: {
                    if (!var6_4.equals("video")) break;
                    var7_5 = 2;
                    break;
                }
                case 110834: {
                    if (!var6_4.equals("pdf")) break;
                    var7_5 = 3;
                    break;
                }
            }
            switch (var7_5) {
                case 0: {
                    mimeType = "audio/mp3";
                    filename = "sound.mp3";
                    ** break;
                }
                case 1: {
                    mimeType = "image/jpeg";
                    filename = "logo.jpg";
                    ** break;
                }
                case 2: {
                    mimeType = "video/mp4";
                    filename = "video.mp4";
                    ** break;
                }
                case 3: {
                    mimeType = "application/pdf";
                    filename = "document.pdf";
                    ** break;
                }
            }
            allowedExtension = Optional.of(definition).map((Function<ElementDefinition, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getWidgetParameters(), (Lorg/ametys/runtime/model/ElementDefinition;)Ljava/util/Map;)()).map((Function<Map, I18nizableText>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$_getGenericFile$5(java.util.Map ), (Ljava/util/Map;)Lorg/ametys/runtime/i18n/I18nizableText;)()).map((Function<I18nizableText, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getLabel(), (Lorg/ametys/runtime/i18n/I18nizableText;)Ljava/lang/String;)()).orElse("");
            if (StringUtils.isBlank((CharSequence)allowedExtension)) {
                mimeType = "image/jpeg";
                filename = "logo.jpg";
                ** break;
            }
            if (allowedExtension.contains("mp3")) {
                mimeType = "audio/mp3";
                filename = "sound.mp3";
                ** break;
            }
            if (allowedExtension.contains("mp4")) {
                mimeType = "video/mp4";
                filename = "video.mp4";
                ** break;
            }
            if (allowedExtension.contains("pdf")) {
                mimeType = "application/pdf";
                filename = "document.pdf";
                ** break;
            }
            if (allowedExtension.contains("vtt")) {
                mimeType = "text/vtt";
                filename = "subtitle.vtt";
                ** break;
            }
            this.getLogger().info(allowedExtension + " is not supported. The file attribute will be ignored");
            var9_11 = null;
        }
        catch (Throwable var10_13) {
            this._sourceResolver.release(ressourceFile);
            throw var10_13;
        }
        this._sourceResolver.release(ressourceFile);
        return var9_11;
lbl-1000:
        // 9 sources

        {
            ressourceFile = this._sourceResolver.resolveURI("plugin:data-filler://filling-data/resources/" + filename);
            file = new Binary();
            is = ressourceFile.getInputStream();
            try {
                file.setInputStream(is);
                file.setMimeType(mimeType);
                file.setFilename(filename);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            var7_6 = file;
        }
        this._sourceResolver.release(ressourceFile);
        return var7_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RichText _getGenericRichText() throws MalformedURLException, IOException, SourceNotFoundException {
        RichText text = new RichText();
        text.setEncoding("UTF-8");
        text.setLastModificationDate(ZonedDateTime.now());
        text.setMimeType("text/xml");
        Source docBookSource = null;
        InputStream is = null;
        try {
            docBookSource = this._sourceResolver.resolveURI("plugin:data-filler://filling-data/resources/richtext.xml");
            is = docBookSource.getInputStream();
            text.setInputStream(is);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            this._sourceResolver.release(docBookSource);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        this._sourceResolver.release(docBookSource);
        return text;
    }

    private UserIdentity _getGenericUser() {
        return this._currentUserProvider.getUser();
    }

    public WorkflowAwareContent getContent(String contentName, Sitemap sitemap) {
        String siteName = sitemap.getSiteName();
        String language = sitemap.getSitemapName();
        LanguageExpression langExp = new LanguageExpression(Expression.Operator.EQ, language);
        StringExpression siteExp = new StringExpression("site", Expression.Operator.EQ, siteName);
        String xPathQuery = QueryHelper.getXPathQuery((String)contentName, (String)"ametys:content", (Expression)new AndExpression(new Expression[]{langExp, siteExp}));
        AmetysObjectIterable contents = this._resolver.query(xPathQuery);
        if (contents.getSize() != 0L) {
            return (WorkflowAwareContent)contents.iterator().next();
        }
        return null;
    }

    public WorkflowAwareContent initializeContent(ContentType contentType, Sitemap sitemap, String contentName) throws WorkflowException {
        String siteName = sitemap.getSiteName();
        String sitemapName = sitemap.getSitemapName();
        String contentTitle = this._i18nUtils.translate((I18nizable)contentType.getLabel(), sitemapName);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap workflowResult = new HashMap();
        params.put(AbstractWorkflowComponent.RESULT_MAP_KEY, workflowResult);
        params.put(CreateContentFunction.SITE_KEY, siteName);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_NAME_KEY, contentName);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TITLE_KEY, contentTitle);
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TYPES_KEY, new String[]{contentType.getId()});
        params.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_LANGUAGE_KEY, sitemapName);
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
        workflow.initialize(contentType.getDefaultWorkflowName().orElse(_CONTENT_WORKFLOW_NAME), 1, params);
        WorkflowAwareContent content = (WorkflowAwareContent)workflowResult.get(AbstractContentWorkflowComponent.CONTENT_KEY);
        return content;
    }

    public WorkflowAwareContent editContent(WorkflowAwareContent content, ContentType contentType, Map<String, Object> values) {
        try {
            this._workflowHelper.editContent(content, values, 2);
            if (this._workflowHelper.isAvailableAction(content, 4)) {
                this._workflowHelper.doAction(content, 4);
            } else {
                this.getLogger().warn("Can't validate content for type {}. The content is not in a valid state after being filled with generic data.", (Object)contentType.getId());
            }
        }
        catch (WorkflowException e) {
            this.getLogger().warn("Something went wrong when trying to edit or validate content of type {}.", (Object)contentType.getId(), (Object)e);
        }
        return content;
    }

    private static /* synthetic */ I18nizableText lambda$_getGenericFile$5(Map params) {
        return (I18nizableText)params.get("allowExtensions");
    }

    private static /* synthetic */ I18nizableText lambda$_getGenericFile$4(Map params) {
        return (I18nizableText)params.get("filter");
    }
}

