/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.datafiller;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.ametys.cms.content.indexing.solr.observation.ObserverHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.indexing.IndexingException;
import org.ametys.cms.indexing.WorkspaceIndexer;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.contentio.synchronize.impl.DefaultSynchronizingContentOperator;
import org.ametys.plugins.datafiller.ClassifiedAdsContentCreationManager;
import org.ametys.plugins.datafiller.GenericContentCreationManager;
import org.ametys.plugins.datafiller.GenericFormCreationManager;
import org.ametys.plugins.datafiller.GenericServiceCreationManager;
import org.ametys.plugins.datafiller.SitemapPopulator;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.linkdirectory.link.LinkDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CreateTestPageManager
extends AbstractLogEnabled
implements Component,
Serviceable,
PluginAware {
    public static final String ROLE = CreateTestPageManager.class.getName();
    private static final String __WEBINF_PARAM_DATAFILLER_SOURCE_DIRECTORY = "context:/WEB-INF/param/datafill/";
    private static final String __SITEMAP_SOURCE_URI = "context:/WEB-INF/param/datafill/sitemap.xml";
    private static final String __LINKDIRECTORY_SOURCE_URI = "context:/WEB-INF/param/datafill/linkdirectory.xml";
    private static final Logger __SCC_LOGGER = LoggerFactory.getLogger(SynchronizableContentsCollection.class);
    private ContentTypeExtensionPoint _cTypeEP;
    private GenericContentCreationManager _genericContentCreationManager;
    private GenericServiceCreationManager _genericServiceCreationManager;
    private GenericFormCreationManager _genericFormCreationManager;
    private ClassifiedAdsContentCreationManager _classifiedAdsContentCreationManager;
    private LinkDAO _linkDAO;
    private AmetysObjectResolver _resolver;
    private AddOrUpdateResourceHelper _resourceHelper;
    private org.ametys.cms.explorer.ExplorerResourcesDAO _resourcesDAO;
    private SynchronizableContentsCollectionDAO _sccDAO;
    private SiteManager _siteManager;
    private SitemapPopulator _sitemapPopulator;
    private SourceResolver _sourceResolver;
    private WorkspaceIndexer _workspaceIndexer;
    private String _fillingDataDirectory;

    public void service(ServiceManager manager) throws ServiceException {
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._genericContentCreationManager = (GenericContentCreationManager)((Object)manager.lookup(GenericContentCreationManager.ROLE));
        this._genericServiceCreationManager = (GenericServiceCreationManager)((Object)manager.lookup(GenericServiceCreationManager.ROLE));
        this._genericFormCreationManager = (GenericFormCreationManager)((Object)manager.lookup(GenericFormCreationManager.ROLE));
        if (manager.hasService(ClassifiedAdsContentCreationManager.ROLE)) {
            this._classifiedAdsContentCreationManager = (ClassifiedAdsContentCreationManager)((Object)manager.lookup(ClassifiedAdsContentCreationManager.ROLE));
        }
        this._linkDAO = (LinkDAO)manager.lookup(LinkDAO.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._resourceHelper = (AddOrUpdateResourceHelper)manager.lookup(AddOrUpdateResourceHelper.ROLE);
        this._resourcesDAO = (org.ametys.cms.explorer.ExplorerResourcesDAO)manager.lookup(ExplorerResourcesDAO.ROLE);
        this._sccDAO = (SynchronizableContentsCollectionDAO)manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._sitemapPopulator = (SitemapPopulator)((Object)manager.lookup(SitemapPopulator.ROLE));
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._workspaceIndexer = (WorkspaceIndexer)manager.lookup(WorkspaceIndexer.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._fillingDataDirectory = "plugin:" + pluginName + "://filling-data/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Data_Filler_Right_Create_Test_Page_Button"})
    public Map<String, Object> createTestPages(String siteName, String language) {
        long startTime = System.currentTimeMillis();
        this.getLogger().info("Starting creating contents, services and pages for tests");
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean success = true;
        try {
            HashSet<String> pagesWithAttachment;
            ObserverHelper.suspendObservationForIndexation();
            Site site = this._siteManager.getSite(siteName);
            Sitemap sitemap = site.getSitemap(language);
            success = this._createSitemaps(sitemap) && success;
            boolean bl = success = this._createTestContentPages(sitemap) && success;
            if (this._classifiedAdsContentCreationManager != null) {
                success = this._createTestClassifiedAdsPages(sitemap) && success;
            }
            success = this._createTestServicePages(sitemap, pagesWithAttachment = new HashSet<String>()) && success;
            success = this._createTestForm(siteName) && success;
            success = this._createLinks(siteName, language) && success;
            success = this._createUserAndOrgUnit() && success;
            success = this._createExplorerResources(pagesWithAttachment) && success;
        }
        finally {
            this.getLogger().info("Reindexing Workspaces...");
            ObserverHelper.restartObservationForIndexation();
            try {
                this._workspaceIndexer.indexAllWorkspaces();
            }
            catch (IndexingException e) {
                success = false;
                this.getLogger().error("An error occurred indexing all workspaces", (Throwable)e);
            }
        }
        long endTime = System.currentTimeMillis();
        this.getLogger().info("End of the creation of contents, services and pages for tests in {} ms", (Object)(endTime - startTime));
        result.put("success", success);
        Collection<String> createdPages = this._sitemapPopulator.getCreatedPages().values();
        result.put("pageIds", createdPages);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createSitemaps(Sitemap sitemap) {
        Source sourceFile = null;
        try {
            sourceFile = this._sourceResolver.resolveURI(__SITEMAP_SOURCE_URI);
            if (sourceFile.exists()) {
                this.getLogger().info("Creating sitemap {}...", (Object)sitemap.getSitemapName());
                this._sitemapPopulator.createSitemap(sitemap, sourceFile);
                this.getLogger().info("End of the sitemap creation");
            }
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred while creating the sitemap...", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._sourceResolver.release(sourceFile);
        }
        return true;
    }

    private boolean _createTestContentPages(Sitemap sitemap) {
        this.getLogger().info("Creating generic content pages");
        try {
            this._genericContentCreationManager.createGenericContentPages(sitemap);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred: failed to create content and add them to test pages", (Throwable)e);
            return false;
        }
        this.getLogger().info("End of generic content pages creation");
        return true;
    }

    private boolean _createTestClassifiedAdsPages(Sitemap sitemap) {
        this.getLogger().info("Creating classified ads pages");
        try {
            this._classifiedAdsContentCreationManager.createClassifiedAdsPages(sitemap);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred: failed to create classified ads root page and create ads", (Throwable)e);
            return false;
        }
        this.getLogger().info("End of classified ads pages creation");
        return true;
    }

    private boolean _createTestServicePages(Sitemap sitemap, Set<String> pageWithAttachmentID) {
        this.getLogger().info("Creating service pages");
        try {
            pageWithAttachmentID.addAll(this._genericServiceCreationManager.createGenericServicePages(sitemap));
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred: failed to create services", (Throwable)e);
            return false;
        }
        this.getLogger().info("End of service pages creation");
        return true;
    }

    private boolean _createTestForm(String sitename) {
        this.getLogger().info("Creating form");
        try {
            this._genericFormCreationManager.createGenericForms(sitename);
        }
        catch (Exception e) {
            this.getLogger().error("An error occurred: failed to create form", (Throwable)e);
            return false;
        }
        this.getLogger().info("End of form creation");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createLinks(String siteName, String lang) {
        block22: {
            Source sourceFile = null;
            try {
                sourceFile = this._sourceResolver.resolveURI(__LINKDIRECTORY_SOURCE_URI);
                if (!sourceFile.exists()) break block22;
                this.getLogger().info("Add link in Link Directory");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                try (InputStream is = sourceFile.getInputStream();){
                    Document doc = docBuilder.parse(is);
                    Element root = doc.getDocumentElement();
                    List linkNodeList = DOMUtils.getChildElementsByTagName((Element)root, (String)"link");
                    for (Element linkElement : linkNodeList) {
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("siteName", siteName);
                        parameters.put("lang", lang);
                        List parameterElementList = DOMUtils.getChildElements((Element)linkElement);
                        for (Element parameterElement : parameterElementList) {
                            String name = parameterElement.getNodeName();
                            String value = parameterElement.getTextContent();
                            parameters.put(name, value);
                        }
                        if (parameters.get("url-type").equals("PAGE")) {
                            String pageURL = (String)parameters.get("url");
                            String pageId = this._sitemapPopulator.getCreatedPages().get(lang + "#" + pageURL);
                            parameters.put("url", pageId);
                        }
                        try {
                            this._linkDAO.createLink(parameters);
                        }
                        catch (IllegalArgumentException e) {
                            this.getLogger().error("Failed to create link {}", parameters.get("title"), (Object)e);
                        }
                    }
                    this.getLogger().info("End of link import");
                }
            }
            catch (IOException e) {
                this.getLogger().error("Can't read source file at {}", (Object)__LINKDIRECTORY_SOURCE_URI, (Object)e);
                boolean bl = false;
                return bl;
            }
            catch (ParserConfigurationException e) {
                this.getLogger().error("Failed to get document parser", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            catch (SAXException e) {
                this.getLogger().error("Failed to parse file at {}", (Object)__LINKDIRECTORY_SOURCE_URI, (Object)e);
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.getLogger().error("Failed to create Link in link directory", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                this._sourceResolver.release(sourceFile);
            }
        }
        return true;
    }

    private boolean _createUserAndOrgUnit() {
        this.getLogger().info("Add user and OrgUnit...");
        String contentTypeId = null;
        Iterator i = this._cTypeEP.getDirectSubTypes("org.ametys.plugins.userdirectory.Content.user").iterator();
        boolean hasOrgUnitView = false;
        while (i.hasNext() && !hasOrgUnitView) {
            contentTypeId = (String)i.next();
            hasOrgUnitView = ((ContentType)this._cTypeEP.getExtension(contentTypeId)).getViewNames().contains("organizationChart");
        }
        if (contentTypeId != null) {
            this._addUserAndOrgunitToDatabase();
            try {
                this._createContentsFromSCC(this._getUserSCCParameters(contentTypeId));
                this._createContentsFromSCC(this._getOrgUnitSCCParameters());
            }
            catch (ProcessingException e) {
                this.getLogger().error("Failed to create user from database", (Throwable)e);
                return false;
            }
            catch (Exception e) {
                this.getLogger().error("Failure while trying to create user data", (Throwable)e);
                return false;
            }
        } else {
            this.getLogger().warn("No content type found for user content. No user content or entity has been generated");
        }
        this.getLogger().info("End of user and OrgUnit import");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addUserAndOrgunitToDatabase() {
        Connection connection = null;
        try {
            String userScriptFile = this._fillingDataDirectory + "scripts/addUsers.sql";
            String orgunitsScriptFile = this._fillingDataDirectory + "scripts/addOrgunits.sql";
            connection = ConnectionHelper.getConnection((String)"SQL-ametys-internal");
            boolean imported = SQLScriptHelper.createTableIfNotExists((Connection)connection, (String)"datafiller_sql_users", (String)userScriptFile, (SourceResolver)this._sourceResolver);
            boolean bl = imported = SQLScriptHelper.createTableIfNotExists((Connection)connection, (String)"datafiller_sql_orgunits", (String)orgunitsScriptFile, (SourceResolver)this._sourceResolver) && imported;
            if (imported) {
                this.getLogger().info("A new database was created for the data-filler user");
            }
            ConnectionHelper.cleanup((Connection)connection);
        }
        catch (IOException | SQLException e) {
            this.getLogger().error("Failed to read import user script", (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    private void _createContentsFromSCC(Map<String, Object> sccParameters) throws ProcessingException {
        String sccLabel = (String)sccParameters.get("label");
        String sccId = sccLabel.toLowerCase().trim().replaceAll("[\\W_]", "-").replaceAll("-+", "-").replaceAll("^-", "");
        SynchronizableContentsCollection requestedSCC = this._sccDAO.getSynchronizableContentsCollection(sccId);
        if (requestedSCC == null) {
            String collectionId = this._sccDAO.addCollection(sccParameters);
            requestedSCC = this._sccDAO.getSynchronizableContentsCollection(collectionId);
        }
        requestedSCC.populate(__SCC_LOGGER, ProgressionTrackerFactory.createContainerProgressionTracker((String)"Populate", (Logger)__SCC_LOGGER));
    }

    private Map<String, Object> _getUserSCCParameters(String contentTypeId) {
        String sccLabel = "Collection d'utilisateurs data-filler";
        HashMap<String, Object> sccParameters = new HashMap<String, Object>();
        sccParameters.put("label", sccLabel);
        sccParameters.put("contentType", contentTypeId);
        sccParameters.put("contentPrefix", "ud-");
        sccParameters.put("workflowName", "user");
        sccParameters.put("initialActionId", 11);
        sccParameters.put("synchronizeActionId", 800);
        sccParameters.put("validateActionId", 41);
        sccParameters.put("validateAfterImport", true);
        sccParameters.put("contentOperator", DefaultSynchronizingContentOperator.class.getName());
        sccParameters.put("languages", List.of("fr"));
        sccParameters.put("modelId", "org.ametys.plugins.contentio.synchronize.collection.sql");
        sccParameters.put("org.ametys.plugins.contentio.synchronize.collection.sql$datasourceId", "SQL-ametys-internal");
        sccParameters.put("org.ametys.plugins.contentio.synchronize.collection.sql$tableName", "datafiller_sql_users");
        sccParameters.put("org.ametys.plugins.contentio.synchronize.collection.sql$idField", "uniqueId");
        sccParameters.put("org.ametys.plugins.contentio.synchronize.collection.sql$mapping", "[{\"metadata-ref\":\"firstname\",\"attribute\":\"prenom\",\"synchro\":false},{\"metadata-ref\":\"lastname\",\"attribute\":\"nom\",\"synchro\":false},{\"metadata-ref\":\"title\",\"attribute\":\"title\",\"synchro\":false},{\"metadata-ref\":\"uniqueId\",\"attribute\":\"login\",\"synchro\":false}]");
        return sccParameters;
    }

    private Map<String, Object> _getOrgUnitSCCParameters() {
        String sccLabel = "Collection d'entit\u00e9s data-filler";
        HashMap<String, Object> sccParameters = new HashMap<String, Object>();
        sccParameters.put("label", sccLabel);
        sccParameters.put("contentType", "org.ametys.plugins.userdirectory.Content.udorgunit");
        sccParameters.put("contentPrefix", "ud-");
        sccParameters.put("workflowName", "udorgunit");
        sccParameters.put("initialActionId", 11);
        sccParameters.put("synchronizeActionId", 800);
        sccParameters.put("validateActionId", 41);
        sccParameters.put("validateAfterImport", true);
        sccParameters.put("contentOperator", DefaultSynchronizingContentOperator.class.getName());
        sccParameters.put("languages", List.of("fr"));
        sccParameters.put("modelId", "org.ametys.plugins.userdirectory.synchronize.orgunit.sql");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$datasourceId", "SQL-ametys-internal");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$tableName", "datafiller_sql_orgunits");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$idField", "orgUnitId");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$orgunitRemoteIdColumnName", "id");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$tableNameUser", "datafiller_sql_users");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$orgUnitJoinColumnName", "orgunitId");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$loginUser", "uniqueId");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$loginColumnName", "login");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$roleColumnName", "role");
        sccParameters.put("org.ametys.plugins.userdirectory.synchronize.orgunit.sql$mapping", "[{\"metadata-ref\":\"title\",\"attribute\":\"title\",\"synchro\":false},{\"metadata-ref\":\"orgUnitId\",\"attribute\":\"id\",\"synchro\":false},{\"metadata-ref\":\"parentOrgUnit\",\"attribute\":\"parentId\",\"synchro\":false},{\"metadata-ref\":\"abstract\",\"attribute\":\"abstract\",\"synchro\":false}]");
        return sccParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _createExplorerResources(Set<String> pageWithAttachment) {
        this.getLogger().info("Adding resources in explorer...");
        String sourceURI = this._fillingDataDirectory + "resources/Dossier de remplissage.zip";
        Source zipSource = null;
        AddOrUpdateResourceHelper.ResourceOperationMode mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD_UNZIP;
        try {
            zipSource = this._sourceResolver.resolveURI(sourceURI);
            String filename = StringUtils.substringAfterLast((String)zipSource.getURI(), (String)"/");
            ModifiableResourceCollection root = (ModifiableResourceCollection)this._resourcesDAO.getResourcesRootNodes().get(0);
            try (InputStream is = zipSource.getInputStream();){
                this._resourceHelper.performResourceOperation(is, filename, root, mode);
            }
            for (String pageId : pageWithAttachment) {
                ModifiablePage attachmentPage = (ModifiablePage)this._resolver.resolveById(pageId);
                root = (ModifiableResourceCollection)attachmentPage.getRootAttachments();
                InputStream is = zipSource.getInputStream();
                try {
                    this._resourceHelper.performResourceOperation(is, filename, root, mode);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            this.getLogger().error("Failed to read source at {}", (Object)sourceURI, (Object)e);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.getLogger().error("Something went wrong", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this._sourceResolver.release(zipSource);
        }
        this.getLogger().info("Resources added in explorer");
        return true;
    }
}

