/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/**
 * This class is a singleton to create all contents / services and pages for integration tests
 */
Ext.define('Ametys.plugins.data.filler.CreateTestPageAction', {
    singleton: true,
    
    /**
     * Create all contents / services and pages for integration tests
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    createAllPage: function(controller)
    {
    	Ametys.Msg.confirm("{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_CONFIRM_TITLE}}", 
				"{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_CONFIRM_MSG}}", 
				Ext.bind(this.createAllPageAct, this, [controller], 1),
				this
		);
    },
    
    createAllPageAct: function(state, controller)
    {
    	if (state == "yes")
    	{
    		controller.refreshing();
	    	Ametys.tool.ToolsManager.openTool('uitool-server-logs', {id: "org.ametys.plugins.datafiller.DataFiller", serverId: controller.getServerId(), category: ["org.ametys.plugins.datafiller.DataFiller"], title: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_LOG_TOOL_TITLE}}"}, "cl");
	    	
	    	Ametys.data.ServerComm.callMethod({
	            role: "org.ametys.plugins.datafiller.CreateTestPageManager",
	            priority: Ametys.data.ServerComm.PRIORITY_LONG_REQUEST,
                methodName: 'createTestPages',
                parameters: [Ametys.getAppParameter("siteName"), Ametys.cms.language.LanguageDAO.getCurrentLanguage()],
	            callback: [{
	                	handler: function(data) {
		    	    		Ext.create("Ametys.message.Message", {
		    	                type: Ametys.message.Message.CREATED,
		    	                targets: {
		    	                    id: Ametys.message.MessageTarget.PAGE,
		    	                    parameters: { 
		    	                    	ids: data.pageIds
		    	                    }
		    	                },
		    	                callback: function()
		    	                {
		    	                	if (data.success)
				    	    	    {
					    	    		Ametys.notify({
					    	    			type: 'info',
					    	    			iconGlyph: 'ametysicon-text70',
					    	    			title: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_SUCCESS_TITLE}}",
					    	    			description: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_SUCCESS_MSG}}"
					    	    		});
				    	    	    }
				    	    		else
			    	    			{
				    	    			Ametys.notify({
					    	    			type: 'error',
					    	    			iconGlyph: 'ametysicon-text70',
					    	    			title: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_ERROR_TITLE}}",
					    	    			description: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_ERROR_MSG}}"
					    	    		});
			    	    			}
		    	                }
		    	            });
		            	},
		                scope: this
	            	},
	            	{
                       handler: function() {
                    	   controller.stopRefreshing();
                       },
                       scope: this,
                       ignoreOnError: false
                    }
	            ],
	            errorMessage: {
	                category: this.self.getName(),
	                msg: "{{i18n PLUGINS_DATA_FILLER_CREATE_TEST_PAGE_DIALOG_ERROR_MSG}}"
	            }
	        });
    	}
    }
});
